/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.ImmutableList;
import forestry.api.genetics.products.IDynamicProductList;
import forestry.api.genetics.products.IMutableProductList;
import forestry.api.genetics.products.IProductList;
import forestry.api.genetics.products.Product;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public final class ProductList
implements IDynamicProductList {
    private final ImmutableList<Product> constantProducts;
    private final ImmutableList<IDynamicProductList> dynamics;

    public ProductList(ImmutableList<Product> constantProducts, ImmutableList<IDynamicProductList> dynamics) {
        this.constantProducts = constantProducts;
        this.dynamics = dynamics;
    }

    @Override
    public Collection<Product> getConstantProducts() {
        return this.constantProducts;
    }

    @Override
    public Collection<Product> getPossibleProducts() {
        ArrayList<Product> products = new ArrayList<Product>((Collection<Product>)this.constantProducts);
        this.dynamics.forEach(IDynamicProductList::getPossibleProducts);
        return products;
    }

    @Override
    public void addProducts(NonNullList<ItemStack> stacks, Function<Product, Float> modifier, Random rand) {
        this.constantProducts.forEach(product -> {
            if (rand.nextFloat() < ((Float)modifier.apply((Product)product)).floatValue()) {
                stacks.add((Object)product.copyStack());
            }
        });
        this.dynamics.forEach(child -> child.addProducts(stacks, modifier, rand));
    }

    @Override
    public void addProducts(IBlockReader reader, BlockPos pos, NonNullList<ItemStack> stacks, Function<Product, Float> modifier, Random rand) {
        this.constantProducts.forEach(product -> {
            if (rand.nextFloat() < ((Float)modifier.apply((Product)product)).floatValue()) {
                stacks.add((Object)product.copyStack());
            }
        });
        this.dynamics.forEach(child -> child.addProducts(reader, pos, stacks, modifier, rand));
    }

    public static class Mutable
    implements IMutableProductList,
    IProductList {
        private final List<Product> products = new ArrayList<Product>();
        private final List<Product.Unbaked> productsUnbaked = new ArrayList<Product.Unbaked>();
        private final List<IMutableProductList> unbakedLists = new ArrayList<IMutableProductList>();
        private final List<IDynamicProductList> dynamicChildren = new ArrayList<IDynamicProductList>();

        @Override
        public IMutableProductList addProduct(ItemStack stack, float chance) {
            this.products.add(new Product(stack, chance));
            return this;
        }

        @Override
        public IMutableProductList addProduct(Supplier<ItemStack> stack, float chance) {
            this.productsUnbaked.add(new Product.Unbaked(stack, chance));
            return this;
        }

        @Override
        public IMutableProductList addList(IMutableProductList list) {
            this.unbakedLists.add(list);
            return this;
        }

        @Override
        public IMutableProductList addDynamic(IDynamicProductList list) {
            this.dynamicChildren.add(list);
            return this;
        }

        @Override
        public Collection<Product> getConstantProducts() {
            return Collections.emptyList();
        }

        @Override
        public void addProducts(NonNullList<ItemStack> stacks, Function<Product, Float> modifier, Random rand) {
        }

        @Override
        public ProductList bake() {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            builder.addAll(this.products);
            this.productsUnbaked.forEach(unbaked -> builder.add((Object)unbaked.bake()));
            this.unbakedLists.forEach(list -> builder.addAll(list.bake().getConstantProducts()));
            return new ProductList((ImmutableList<Product>)builder.build(), (ImmutableList<IDynamicProductList>)ImmutableList.copyOf(this.dynamicChildren));
        }
    }
}

