/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IGenome;
import genetics.api.individual.IGenomeMatcher;
import genetics.api.root.IIndividualRoot;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class TemplateMatcher
implements IGenomeMatcher {
    private final IGenome genome;
    @Nullable
    private Boolean matches = null;

    public TemplateMatcher(IGenome genome) {
        this.genome = genome;
    }

    @Override
    public IGenome getFirst() {
        return this.genome;
    }

    @Override
    public IGenome getSecond() {
        return this.genome.getKaryotype().getDefaultGenome();
    }

    @Override
    public IIndividualRoot getRoot() {
        return GeneticsAPI.apiInstance.getRoot(this.genome.getKaryotype().getUID()).get();
    }

    @Override
    public boolean matches() {
        if (this.matches == null) {
            this.matches = this.calculateMatches();
        }
        return this.matches;
    }

    private boolean calculateMatches() {
        IAlleleSpecies primary = this.genome.getPrimary();
        IAllele[] template = this.getRoot().getTemplates().getTemplate(primary.getRegistryName().toString());
        IChromosome[] chromosomes = this.genome.getChromosomes();
        for (int i = 0; i < chromosomes.length; ++i) {
            IChromosome chromosome = chromosomes[i];
            ResourceLocation templateUid = template[i].getRegistryName();
            IAllele activeAllele = chromosome.getActiveAllele();
            if (!activeAllele.getRegistryName().equals((Object)templateUid)) {
                return false;
            }
            IAllele inactiveAllele = chromosome.getInactiveAllele();
            if (inactiveAllele.getRegistryName().equals((Object)templateUid)) continue;
            return false;
        }
        return true;
    }
}

