/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IGeneticRegistry;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.alleles.IAlleleHandler;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.core.features.CoreItems;
import forestry.core.genetics.ItemResearchNote;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.modules.ModuleHelper;
import genetics.api.alleles.AlleleCategorizedValue;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleValue;
import genetics.api.classification.IClassification;
import genetics.api.classification.IClassificationRegistry;
import genetics.api.mutation.IMutation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class GeneticRegistry
implements IGeneticRegistry {
    private final LinkedHashMap<String, IFruitFamily> fruitMap = new LinkedHashMap(64);
    private final Set<IAlleleHandler> alleleHandlers = new HashSet<IAlleleHandler>();

    public void registerClassifications(IClassificationRegistry registry) {
        registry.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "archaea", "Archaea");
        registry.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "bacteria", "Bacteria");
        IClassification eukarya = registry.createAndRegisterClassification(IClassification.EnumClassLevel.DOMAIN, "eukarya", "Eukarya");
        eukarya.addMemberGroup(registry.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "animalia", "Animalia"));
        eukarya.addMemberGroup(registry.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "plantae", "Plantae"));
        eukarya.addMemberGroup(registry.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "fungi", "Fungi"));
        eukarya.addMemberGroup(registry.createAndRegisterClassification(IClassification.EnumClassLevel.KINGDOM, "protista", "Protista"));
        registry.getClassification("kingdom.animalia").addMemberGroup(registry.createAndRegisterClassification(IClassification.EnumClassLevel.PHYLUM, "arthropoda", "Arthropoda"));
        registry.getClassification("phylum.arthropoda").addMemberGroup(registry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "insecta", "Insecta"));
    }

    public void registerAlleles(IAlleleRegistry registry) {
        if (ModuleHelper.anyEnabled("apiculture", "lepidopterology")) {
            registry.registerAlleles(EnumAllele.Speed.values(), BeeChromosomes.SPEED, ButterflyChromosomes.SPEED);
            registry.registerAlleles(EnumAllele.Lifespan.values(), BeeChromosomes.LIFESPAN, ButterflyChromosomes.LIFESPAN);
            registry.registerAlleles(EnumAllele.Tolerance.values(), BeeChromosomes.TEMPERATURE_TOLERANCE, BeeChromosomes.HUMIDITY_TOLERANCE, ButterflyChromosomes.TEMPERATURE_TOLERANCE, ButterflyChromosomes.HUMIDITY_TOLERANCE);
            registry.registerAlleles(EnumAllele.Flowers.values(), BeeChromosomes.FLOWER_PROVIDER, ButterflyChromosomes.FLOWER_PROVIDER);
        }
        if (ModuleHelper.isEnabled("lepidopterology")) {
            registry.registerAlleles(EnumAllele.Size.values(), ButterflyChromosomes.SIZE);
        }
        for (int i = 1; i <= 10; ++i) {
            registry.registerAllele("i", i + "d", i, true, TreeChromosomes.GIRTH, ButterflyChromosomes.METABOLISM, ButterflyChromosomes.FERTILITY);
        }
        HashMap<Boolean, AlleleCategorizedValue<Boolean>> booleans = new HashMap<Boolean, AlleleCategorizedValue<Boolean>>();
        booleans.put(true, new AlleleCategorizedValue<Boolean>("forestry", "bool", "true", true, false));
        booleans.put(false, new AlleleCategorizedValue<Boolean>("forestry", "bool", "false", false, false));
        for (IAlleleValue alleleBoolean : booleans.values()) {
            registry.registerAllele(alleleBoolean, BeeChromosomes.NEVER_SLEEPS, BeeChromosomes.TOLERATES_RAIN, BeeChromosomes.CAVE_DWELLING, ButterflyChromosomes.NOCTURNAL, ButterflyChromosomes.TOLERANT_FLYER, ButterflyChromosomes.FIRE_RESIST);
        }
    }

    @Override
    public void registerFruitFamily(IFruitFamily family) {
        this.fruitMap.put(family.getUID(), family);
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterFruitFamily(family);
        }
    }

    @Override
    public Map<String, IFruitFamily> getRegisteredFruitFamilies() {
        return Collections.unmodifiableMap(this.fruitMap);
    }

    @Override
    public IFruitFamily getFruitFamily(String uid) {
        return this.fruitMap.get(uid);
    }

    @Override
    public void registerAlleleHandler(IAlleleHandler handler) {
        this.alleleHandlers.add(handler);
    }

    @Override
    public ItemStack getSpeciesNoteStack(GameProfile researcher, IAlleleForestrySpecies species) {
        return ItemResearchNote.EnumNoteType.createSpeciesNoteStack(CoreItems.RESEARCH_NOTE.item(), researcher, species);
    }

    @Override
    public ItemStack getMutationNoteStack(GameProfile researcher, IMutation mutation) {
        return ItemResearchNote.EnumNoteType.createMutationNoteStack(CoreItems.RESEARCH_NOTE.item(), researcher, mutation);
    }
}

