/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import com.google.common.base.MoreObjects;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IMutationBuilder;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.genetics.mutations.MutationConditionBiome;
import forestry.core.genetics.mutations.MutationConditionDaytime;
import forestry.core.genetics.mutations.MutationConditionHumidity;
import forestry.core.genetics.mutations.MutationConditionRequiresResource;
import forestry.core.genetics.mutations.MutationConditionTemperature;
import forestry.core.genetics.mutations.MutationConditionTimeLimited;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IGenome;
import genetics.api.mutation.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class Mutation
implements IMutation,
IMutationBuilder {
    private final int chance;
    private final IAlleleForestrySpecies firstParent;
    private final IAlleleForestrySpecies secondParent;
    private final IAllele[] template;
    private final List<IMutationCondition> mutationConditions = new ArrayList<IMutationCondition>();
    private final List<ITextComponent> specialConditions = new ArrayList<ITextComponent>();
    private boolean isSecret = false;

    protected Mutation(IAlleleForestrySpecies firstParent, IAlleleForestrySpecies secondParent, IAllele[] template, int chance) {
        this.firstParent = firstParent;
        this.secondParent = secondParent;
        this.template = template;
        this.chance = chance;
    }

    @Override
    public Collection<ITextComponent> getSpecialConditions() {
        return this.specialConditions;
    }

    @Override
    public Mutation setIsSecret() {
        this.isSecret = true;
        return this;
    }

    @Override
    public Mutation restrictTemperature(EnumTemperature temperature) {
        return this.restrictTemperature(temperature, temperature);
    }

    @Override
    public Mutation restrictTemperature(EnumTemperature minTemperature, EnumTemperature maxTemperature) {
        MutationConditionTemperature mutationCondition = new MutationConditionTemperature(minTemperature, maxTemperature);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation restrictHumidity(EnumHumidity humidity) {
        return this.restrictHumidity(humidity, humidity);
    }

    @Override
    public Mutation restrictHumidity(EnumHumidity minHumidity, EnumHumidity maxHumidity) {
        MutationConditionHumidity mutationCondition = new MutationConditionHumidity(minHumidity, maxHumidity);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation restrictBiomeType(Biome.Category ... types) {
        MutationConditionBiome mutationCondition = new MutationConditionBiome(types);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation requireDay() {
        MutationConditionDaytime mutationCondition = new MutationConditionDaytime(true);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation requireNight() {
        MutationConditionDaytime mutationCondition = new MutationConditionDaytime(false);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation restrictDateRange(int startMonth, int startDay, int endMonth, int endDay) {
        MutationConditionTimeLimited mutationCondition = new MutationConditionTimeLimited(startMonth, startDay, endMonth, endDay);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation requireResource(BlockState ... acceptedBlockStates) {
        MutationConditionRequiresResource mutationCondition = new MutationConditionRequiresResource(acceptedBlockStates);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation addMutationCondition(IMutationCondition mutationCondition) {
        this.mutationConditions.add(mutationCondition);
        this.specialConditions.add(mutationCondition.getDescription());
        return this;
    }

    protected float getChance(World world, BlockPos pos, IAllele firstParent, IAllele secondParent, IGenome firstGenome, IGenome secondGenome, IClimateProvider climate) {
        float mutationChance = this.chance;
        for (IMutationCondition mutationCondition : this.mutationConditions) {
            if ((mutationChance *= mutationCondition.getChance(world, pos, firstParent, secondParent, firstGenome, secondGenome, climate)) != 0.0f) continue;
            return 0.0f;
        }
        return mutationChance;
    }

    @Override
    public IAlleleSpecies getFirstParent() {
        return this.firstParent;
    }

    @Override
    public IAlleleSpecies getSecondParent() {
        return this.secondParent;
    }

    @Override
    public IAlleleSpecies getResultingSpecies() {
        return (IAlleleSpecies)this.template[0];
    }

    @Override
    public float getBaseChance() {
        return this.chance;
    }

    @Override
    public IAllele[] getTemplate() {
        return this.template;
    }

    @Override
    public boolean isPartner(IAllele allele) {
        return this.firstParent.getRegistryName().equals((Object)allele.getRegistryName()) || this.secondParent.getRegistryName().equals((Object)allele.getRegistryName());
    }

    @Override
    public IAllele getPartner(IAllele allele) {
        if (this.firstParent.getRegistryName().equals((Object)allele.getRegistryName())) {
            return this.secondParent;
        }
        if (this.secondParent.getRegistryName().equals((Object)allele.getRegistryName())) {
            return this.firstParent;
        }
        throw new IllegalArgumentException("Tried to get partner for allele that is not part of this mutation.");
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("first", (Object)this.firstParent).add("second", (Object)this.secondParent).add("result", (Object)this.template[0]);
        if (!this.specialConditions.isEmpty()) {
            stringHelper.add("conditions", this.getSpecialConditions());
        }
        return stringHelper.toString();
    }
}

