/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IMutationCondition;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class MutationConditionBiome
implements IMutationCondition {
    private final List<Biome.Category> validBiomeTypes;

    public MutationConditionBiome(Biome.Category ... types) {
        this.validBiomeTypes = Arrays.asList(types);
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        Biome biome = climate.getBiome();
        for (Biome.Category category : this.validBiomeTypes) {
            if (biome.func_201856_r() != category) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public ITextComponent getDescription() {
        if (this.validBiomeTypes.size() > 1) {
            String biomeTypes = Arrays.toString(this.validBiomeTypes.toArray()).toLowerCase(Locale.ENGLISH);
            return new TranslationTextComponent("for.mutation.condition.biome.multiple", new Object[]{biomeTypes});
        }
        String biomeType = this.validBiomeTypes.get(0).toString().toLowerCase(Locale.ENGLISH);
        return new TranslationTextComponent("for.mutation.condition.biome.single", new Object[]{biomeType});
    }
}

