/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.climate.IClimateProvider;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.core.utils.Translator;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MutationConditionTemperature
implements IMutationCondition {
    private final EnumTemperature minTemperature;
    private final EnumTemperature maxTemperature;

    public MutationConditionTemperature(EnumTemperature minTemperature, EnumTemperature maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        EnumTemperature biomeTemperature = climate.getTemperature();
        if (biomeTemperature.ordinal() < this.minTemperature.ordinal() || biomeTemperature.ordinal() > this.maxTemperature.ordinal()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public ITextComponent getDescription() {
        String minString = AlleleManager.climateHelper.toDisplay(this.minTemperature).getString();
        if (this.minTemperature != this.maxTemperature) {
            String maxString = AlleleManager.climateHelper.toDisplay(this.maxTemperature).getString();
            return new StringTextComponent(Translator.translateToLocal("for.mutation.condition.temperature.range").replace("%LOW", minString).replace("%HIGH", maxString));
        }
        return new TranslationTextComponent("for.mutation.condition.temperature.single", new Object[]{minString});
    }
}

