/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.root;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IBreedingTrackerHandler;
import forestry.api.genetics.IBreedingTrackerManager;
import forestry.core.genetics.root.ClientBreedingHandler;
import forestry.core.genetics.root.ServerBreedingHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.DistExecutor;

public enum BreedingTrackerManager implements IBreedingTrackerManager
{
    INSTANCE;

    static final Map<String, IBreedingTrackerHandler> factories;
    @Nullable
    private SidedHandler sidedHandler = (SidedHandler)DistExecutor.safeRunForDist(() -> ClientBreedingHandler::new, () -> ServerBreedingHandler::new);

    @Override
    public void registerTracker(String rootUID, IBreedingTrackerHandler handler) {
        factories.put(rootUID, handler);
    }

    @Override
    public <T extends IBreedingTracker> T getTracker(String rootUID, IWorld world, @Nullable GameProfile profile) {
        return this.getSidedHandler().getTracker(rootUID, world, profile);
    }

    private SidedHandler getSidedHandler() {
        Preconditions.checkNotNull((Object)this.sidedHandler, (Object)"Called breeding tracker method to early.");
        return this.sidedHandler;
    }

    static {
        factories = new LinkedHashMap<String, IBreedingTrackerHandler>();
    }

    static interface SidedHandler {
        public <T extends IBreedingTracker> T getTracker(String var1, IWorld var2, @Nullable GameProfile var3);
    }
}

