/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.root;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IBreedingTrackerHandler;
import forestry.core.genetics.root.BreedingTrackerManager;
import forestry.core.genetics.root.ServerBreedingHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ClientBreedingHandler
extends ServerBreedingHandler {
    private final Map<String, IBreedingTracker> trackerByUID = new LinkedHashMap<String, IBreedingTracker>();

    @Override
    public <T extends IBreedingTracker> T getTracker(String rootUID, IWorld world, @Nullable GameProfile profile) {
        if (world instanceof ServerWorld) {
            return super.getTracker(rootUID, world, profile);
        }
        IBreedingTrackerHandler handler = BreedingTrackerManager.factories.get(rootUID);
        String filename = handler.getFileName(profile);
        IBreedingTracker tracker = this.trackerByUID.computeIfAbsent(rootUID, key -> handler.createTracker(filename));
        handler.populateTracker(tracker, (World)Minecraft.func_71410_x().field_71441_e, profile);
        return (T)tracker;
    }
}

