/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.slots.SlotForestry;
import forestry.core.gui.slots.SlotLocked;
import forestry.core.network.IForestryPacketClient;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SlotUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerForestry
extends Container {
    public static final int PLAYER_HOTBAR_OFFSET = 27;
    public static final int PLAYER_INV_SLOTS = 36;
    private int transferCount = 0;

    protected ContainerForestry(int windowId, ContainerType<?> type) {
        super(type, windowId);
    }

    protected final void addPlayerInventory(PlayerInventory playerInventory, int xInv, int yInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(playerInventory, column + row * 9 + 9, xInv + column * 18, yInv + row * 18);
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addHotbarSlot(playerInventory, column, xInv + column * 18, yInv + 58);
        }
    }

    protected void addHotbarSlot(PlayerInventory playerInventory, int slot, int x, int y) {
        super.func_75146_a(new Slot((IInventory)playerInventory, slot, x, y));
    }

    protected void addSlot(PlayerInventory playerInventory, int slot, int x, int y) {
        super.func_75146_a(new Slot((IInventory)playerInventory, slot, x, y));
    }

    public Slot func_75146_a(Slot slot) {
        return super.func_75146_a(slot);
    }

    public ItemStack func_184996_a(int slotId, int dragType_or_button, ClickType clickTypeIn, PlayerEntity player) {
        SlotForestry slotForestry;
        Slot slot;
        int hotbarSlotIndex;
        Slot hotbarSlot;
        if (!this.canAccess(player)) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.SWAP && dragType_or_button >= 0 && dragType_or_button < 9 && (hotbarSlot = this.func_75139_a(hotbarSlotIndex = 27 + dragType_or_button)) instanceof SlotLocked) {
            return ItemStack.field_190927_a;
        }
        Slot slot2 = slot = slotId < 0 ? null : this.func_75139_a(slotId);
        if (slot instanceof SlotForestry && (slotForestry = (SlotForestry)slot).isPhantom()) {
            return SlotUtil.slotClickPhantom(slotForestry, dragType_or_button, clickTypeIn, player);
        }
        this.transferCount = 0;
        return super.func_184996_a(slotId, dragType_or_button, clickTypeIn, player);
    }

    public Slot getForestrySlot(int slot) {
        return this.func_75139_a(36 + slot);
    }

    public final ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        if (!this.canAccess(player)) {
            return ItemStack.field_190927_a;
        }
        if (this.transferCount < 64) {
            ++this.transferCount;
            return SlotUtil.transferStackInSlot(this.field_75151_b, player, slotIndex);
        }
        return ItemStack.field_190927_a;
    }

    protected abstract boolean canAccess(PlayerEntity var1);

    protected final void sendPacketToListeners(IForestryPacketClient packet) {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof PlayerEntity)) continue;
            NetworkUtil.sendToPlayer(packet, (PlayerEntity)listener);
        }
    }
}

