/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IToolPipette;
import forestry.core.fluids.StandardTank;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.network.packets.PacketPipetteClick;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.NetworkUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ContainerLiquidTanksHelper<T extends TileEntity>
implements IContainerLiquidTanks {
    private final T tile;

    public ContainerLiquidTanksHelper(T tile) {
        this.tile = tile;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePipetteClickClient(int slot, PlayerEntity player) {
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack.func_77973_b() instanceof IToolPipette) {
            NetworkUtil.sendToServer(new PacketPipetteClick(slot));
        }
    }

    @Override
    public void handlePipetteClick(int slot, ServerPlayerEntity player) {
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        Item held = itemstack.func_77973_b();
        if (!(held instanceof IToolPipette)) {
            return;
        }
        IToolPipette pipette = (IToolPipette)held;
        IFluidTank tank = ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
        int liquidAmount = tank.getFluidAmount();
        LazyOptional fluidCap = FluidUtil.getFluidHandler((ItemStack)itemstack);
        fluidCap.ifPresent(fluidHandlerItem -> {
            if (pipette.canPipette(itemstack) && liquidAmount > 0) {
                if (tank instanceof StandardTank) {
                    FluidStack fillAmount = ((StandardTank)tank).drainInternal(1000, IFluidHandler.FluidAction.EXECUTE);
                    int filled = fluidHandlerItem.fill(fillAmount, IFluidHandler.FluidAction.EXECUTE);
                    tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    player.field_71071_by.func_70437_b(fluidHandlerItem.getContainer());
                    player.func_71113_k();
                } else {
                    FluidStack fillAmount = tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    int filled = fluidHandlerItem.fill(fillAmount, IFluidHandler.FluidAction.EXECUTE);
                    tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    player.field_71071_by.func_70437_b(fluidHandlerItem.getContainer());
                    player.func_71113_k();
                }
            } else {
                FluidStack potential = fluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (!potential.isEmpty() && tank instanceof FluidTank) {
                    int fill = tank.fill(potential, IFluidHandler.FluidAction.EXECUTE);
                    fluidHandlerItem.drain(fill, IFluidHandler.FluidAction.EXECUTE);
                    player.field_71071_by.func_70437_b(fluidHandlerItem.getContainer());
                    player.func_71113_k();
                }
            }
        });
    }

    @Override
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }
}

