/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.alleles.IAlleleValue;
import genetics.api.classification.IClassification;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.ComponentKeys;
import genetics.utils.AlleleUtils;
import genetics.utils.RootUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.StringUtils;

public class GuiAlyzer
extends GuiForestry<ContainerAlyzer> {
    public static final int COLUMN_0 = 12;
    public static final int COLUMN_1 = 90;
    public static final int COLUMN_2 = 155;
    private final ItemInventoryAlyzer itemInventory;

    public GuiAlyzer(ContainerAlyzer container, PlayerInventory playerInv, ITextComponent name) {
        super("textures/gui/portablealyzer.png", container, playerInv, (ITextComponent)new StringTextComponent("GUI_ALYZER_TEST_TITLE"));
        this.itemInventory = (ItemInventoryAlyzer)container.inventory;
        this.field_146999_f = 246;
        this.field_147000_g = 238;
    }

    public final int getColorCoding(boolean dominant) {
        if (dominant) {
            return ColourProperties.INSTANCE.get("gui.beealyzer.dominant");
        }
        return ColourProperties.INSTANCE.get("gui.beealyzer.recessive");
    }

    public final void drawLine(MatrixStack transform, String text, int x, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.textLayout.drawLine(transform, text, x, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.textLayout.drawLine(transform, text, x, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    public final void drawSplitLine(String text, int x, int maxWidth, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.textLayout.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.textLayout.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    public final void drawSplitLine(ITextComponent component, int x, int maxWidth, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.textLayout.drawSplitLine(component, x, maxWidth, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.textLayout.drawSplitLine(component, x, maxWidth, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    public final void drawRow(MatrixStack transform, String text0, String text1, String text2, IIndividual individual, IChromosomeType chromosome) {
        this.textLayout.drawRow(transform, text0, text1, text2, ColourProperties.INSTANCE.get("gui.screen"), this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()), this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
    }

    public final void drawChromosomeRow(MatrixStack transform, String chromosomeName, IIndividual individual, IChromosomeType chromosome) {
        IAllele active = individual.getGenome().getActiveAllele(chromosome);
        IAllele inactive = individual.getGenome().getInactiveAllele(chromosome);
        this.textLayout.drawRow(transform, chromosomeName, active.getDisplayName().getString(), inactive.getDisplayName().getString(), ColourProperties.INSTANCE.get("gui.screen"), this.getColorCoding(active.isDominant()), this.getColorCoding(inactive.isDominant()));
    }

    public final void drawSpeciesRow(MatrixStack transform, String text0, IIndividual individual, IChromosomeType chromosome, IOrganismType type) {
        IAlleleForestrySpecies primary = (IAlleleForestrySpecies)individual.getGenome().getPrimary();
        IAlleleForestrySpecies secondary = (IAlleleForestrySpecies)individual.getGenome().getSecondary();
        this.textLayout.drawLine(transform, text0, this.textLayout.column0);
        int columnwidth = this.textLayout.column2 - this.textLayout.column1 - 2;
        Map<ResourceLocation, ItemStack> iconStacks = ((IForestrySpeciesRoot)chromosome.getRoot()).getAlyzerPlugin().getIconStacks();
        GuiUtil.drawItemStack(this, iconStacks.get(primary.getRegistryName()), this.field_147003_i + this.textLayout.column1 + columnwidth - 20, this.field_147009_r + 10);
        GuiUtil.drawItemStack(this, iconStacks.get(secondary.getRegistryName()), this.field_147003_i + this.textLayout.column2 + columnwidth - 20, this.field_147009_r + 10);
        ITextComponent primaryName = primary.getAlyzerName(type);
        ITextComponent secondaryName = primary.getAlyzerName(type);
        this.drawSplitLine(primaryName, this.textLayout.column1, columnwidth, individual, chromosome, false);
        this.drawSplitLine(secondaryName, this.textLayout.column2, columnwidth, individual, chromosome, true);
        this.textLayout.newLine();
    }

    @Nullable
    public static String checkCustomName(String key) {
        if (Translator.canTranslateToLocal(key)) {
            return Translator.translateToLocal(key);
        }
        return null;
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(transform, partialTicks, mouseX, mouseY);
        this.widgetManager.clear();
        int specimenSlot = this.getSpecimenSlot();
        if (specimenSlot < 2) {
            this.drawAnalyticsOverview(transform);
            return;
        }
        ItemStack stackInSlot = this.itemInventory.func_70301_a(specimenSlot);
        IRootDefinition definition = RootUtils.getRoot(stackInSlot);
        if (!definition.isPresent()) {
            return;
        }
        IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)definition.get();
        switch (specimenSlot) {
            case 2: {
                speciesRoot.getAlyzerPlugin().drawAnalyticsPage1(transform, (Screen)this, stackInSlot);
                break;
            }
            case 3: {
                speciesRoot.getAlyzerPlugin().drawAnalyticsPage2(transform, (Screen)this, stackInSlot);
                break;
            }
            case 4: {
                speciesRoot.getAlyzerPlugin().drawAnalyticsPage3(transform, stackInSlot, (Screen)this);
                break;
            }
            case 5: {
                speciesRoot.create(stackInSlot).ifPresent(value -> this.drawAnalyticsPageMutations(transform, (IIndividual)value));
                break;
            }
            case 6: {
                speciesRoot.create(stackInSlot).ifPresent(value -> this.drawAnalyticsPageClassification(transform, (IIndividual)value));
                break;
            }
            default: {
                this.drawAnalyticsOverview(transform);
            }
        }
    }

    private int getSpecimenSlot() {
        for (int k = 1; k <= 6; ++k) {
            IForestrySpeciesRoot speciesRoot;
            Optional optionalIndividual;
            IRootDefinition definition;
            ItemStack stackInSlot = this.itemInventory.func_70301_a(k);
            if (stackInSlot.func_190926_b() || !(definition = RootUtils.getRoot(stackInSlot)).isPresent() || (optionalIndividual = (speciesRoot = (IForestrySpeciesRoot)definition.get()).create(stackInSlot)).filter(individual -> !individual.isAnalyzed()).isPresent()) continue;
            return k;
        }
        return -1;
    }

    public void drawAnalyticsOverview(MatrixStack transform) {
        this.textLayout.startPage();
        this.textLayout.newLine();
        String title = Translator.translateToLocal("for.gui.portablealyzer").toUpperCase(Locale.ENGLISH);
        this.textLayout.drawCenteredLine(transform, title, 8, 208, ColourProperties.INSTANCE.get("gui.screen"));
        this.textLayout.newLine();
        this.getFontRenderer().func_238418_a_((ITextProperties)new TranslationTextComponent("for.gui.portablealyzer.help"), this.field_147003_i + 12 + 4, this.field_147009_r + 42, 200, ColourProperties.INSTANCE.get("gui.screen"));
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.alyzer.overview") + ":", 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(transform, "I  : " + Translator.translateToLocal("for.gui.general"), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(transform, "II : " + Translator.translateToLocal("for.gui.environment"), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(transform, "III: " + Translator.translateToLocal("for.gui.produce"), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine(transform, "IV : " + Translator.translateToLocal("for.gui.evolution"), 16);
        this.textLayout.endPage();
    }

    public final void drawAnalyticsPageClassification(MatrixStack transform, IIndividual individual) {
        this.textLayout.startPage();
        this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.alyzer.classification") + ":", 12);
        this.textLayout.newLine();
        Stack<IClassification> hierarchy = new Stack<IClassification>();
        for (IClassification classification = individual.getGenome().getPrimary().getBranch(); classification != null; classification = classification.getParent()) {
            if (classification.getScientific().isEmpty()) continue;
            hierarchy.push(classification);
        }
        boolean overcrowded = hierarchy.size() > 5;
        int x = 12;
        IClassification group = null;
        while (!hierarchy.isEmpty()) {
            group = (IClassification)hierarchy.pop();
            if (overcrowded && group.getLevel().isDroppable()) continue;
            this.textLayout.drawLine(transform, group.getScientific(), x, group.getLevel().getColour());
            this.textLayout.drawLine(transform, group.getLevel().name(), 170, group.getLevel().getColour());
            this.textLayout.newLineCompressed();
            x += 12;
        }
        String binomial = individual.getGenome().getPrimary().getBinomial();
        if (group != null && group.getLevel() == IClassification.EnumClassLevel.GENUS) {
            binomial = group.getScientific().substring(0, 1) + ". " + binomial.toLowerCase(Locale.ENGLISH);
        }
        this.textLayout.drawLine(transform, binomial, x, 15445637);
        this.textLayout.drawLine(transform, "SPECIES", 170, 15445637);
        this.textLayout.newLine();
        this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.alyzer.authority") + ": " + individual.getGenome().getPrimary().getAuthority(), 12);
        if (AlleleUtils.isBlacklisted(individual.getIdentifier())) {
            String extinct = ">> " + Translator.translateToLocal("for.gui.alyzer.extinct").toUpperCase(Locale.ENGLISH) + " <<";
            this.getFontRenderer().func_238405_a_(transform, extinct, (float)(this.field_147003_i + 200 - this.getFontRenderer().func_78256_a(extinct)), (float)(this.field_147009_r + this.textLayout.getLineY()), ColourProperties.INSTANCE.get("gui.beealyzer.dominant"));
        }
        this.textLayout.newLine();
        String description = individual.getGenome().getPrimary().getDescription().getString();
        if (StringUtils.isBlank((CharSequence)description) || description.startsWith("for.description.")) {
            this.textLayout.drawSplitLine(Translator.translateToLocal("for.gui.alyzer.nodescription"), 12, 200, 0x666666);
        } else {
            String[] tokens = description.split("\\|");
            this.textLayout.drawSplitLine(tokens[0], 12, 200, 0x666666);
            if (tokens.length > 1) {
                String signature = "- " + tokens[1];
                this.getFontRenderer().func_238405_a_(transform, signature, (float)(this.field_147003_i + 210 - this.getFontRenderer().func_78256_a(signature)), (float)(this.field_147009_r + 145 - 14), 10079282);
            }
        }
        this.textLayout.endPage();
    }

    public void drawAnalyticsPageMutations(MatrixStack transform, IIndividual individual) {
        this.textLayout.startPage(12, 90, 155);
        this.textLayout.drawLine(transform, Translator.translateToLocal("for.gui.beealyzer.mutations") + ":", 12);
        this.textLayout.newLine();
        IGenome genome = individual.getGenome();
        IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)individual.getRoot();
        IAlleleSpecies species = genome.getPrimary();
        int columnWidth = 50;
        int x = 0;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker((IWorld)player.field_70170_p, player.func_146103_bH());
        IMutationContainer container = (IMutationContainer)speciesRoot.getComponent(ComponentKeys.MUTATIONS);
        for (IMutation mutation : container.getCombinations(species)) {
            if (breedingTracker.isDiscovered(mutation)) {
                this.drawMutationInfo(transform, mutation, species, 12 + x, breedingTracker);
            } else {
                if (mutation.isSecret()) continue;
                this.drawUnknownMutation(transform, mutation, 12 + x, breedingTracker);
            }
            if ((x += columnWidth) < columnWidth * 4) continue;
            x = 0;
            this.textLayout.newLine(16);
        }
        this.textLayout.endPage();
    }

    public void drawMutationInfo(MatrixStack transform, IMutation combination, IAllele species, int x, IBreedingTracker breedingTracker) {
        Map<ResourceLocation, ItemStack> iconStacks = ((IForestrySpeciesRoot)combination.getRoot()).getAlyzerPlugin().getIconStacks();
        ItemStack partnerBee = iconStacks.get(combination.getPartner(species).getRegistryName());
        this.widgetManager.add(new ItemStackWidget(this.widgetManager, x, this.textLayout.getLineY(), partnerBee));
        this.drawProbabilityArrow(transform, combination, this.field_147003_i + x + 18, this.field_147009_r + this.textLayout.getLineY() + 4, breedingTracker);
        IAllele result = combination.getTemplate()[BeeChromosomes.SPECIES.ordinal()];
        ItemStack resultBee = iconStacks.get(result.getRegistryName());
        this.widgetManager.add(new ItemStackWidget(this.widgetManager, x + 33, this.textLayout.getLineY(), resultBee));
    }

    private void drawUnknownMutation(MatrixStack transform, IMutation combination, int x, IBreedingTracker breedingTracker) {
        this.drawQuestionMark(transform, this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY());
        this.drawProbabilityArrow(transform, combination, this.field_147003_i + x + 18, this.field_147009_r + this.textLayout.getLineY() + 4, breedingTracker);
        this.drawQuestionMark(transform, this.field_147003_i + x + 32, this.field_147009_r + this.textLayout.getLineY());
    }

    private void drawQuestionMark(MatrixStack transform, int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, x, y, 78, 240, 16, 16);
    }

    private void drawProbabilityArrow(MatrixStack transform, IMutation combination, int x, int y, IBreedingTracker breedingTracker) {
        float chance = combination.getBaseChance();
        int line = 247;
        int column = 100;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 100;
                break;
            }
            case HIGHER: {
                column = 115;
                break;
            }
            case HIGH: {
                column = 130;
                break;
            }
            case NORMAL: {
                column = 145;
                break;
            }
            case LOW: {
                column = 160;
                break;
            }
            case LOWEST: {
                column = 175;
            }
        }
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, x, y, column, line, 15, 9);
        boolean researched = breedingTracker.isResearched(combination);
        if (researched) {
            this.getFontRenderer().func_238421_b_(transform, "+", (float)(x + 9), (float)(y + 1), 0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawToleranceInfo(MatrixStack transform, IAlleleValue<EnumTolerance> toleranceAllele, int x) {
        int textColor = this.getColorCoding(toleranceAllele.isDominant());
        EnumTolerance tolerance = toleranceAllele.getValue();
        String text = "(" + toleranceAllele.getDisplayName().getString() + ")";
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(transform, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(transform, text, x + 14, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(transform, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(transform, text, x + 14, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(transform, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(transform, text, x + 14, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(transform, x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(transform, "(0)", x + 14, textColor);
            }
        }
    }

    private void drawDownSymbol(MatrixStack transform, int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i + x, this.field_147009_r + y, 0, 247, 15, 9);
    }

    private void drawUpSymbol(MatrixStack transform, int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i + x, this.field_147009_r + y, 15, 247, 15, 9);
    }

    private void drawBothSymbol(MatrixStack transform, int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i + x, this.field_147009_r + y, 30, 247, 15, 9);
    }

    private void drawNoneSymbol(MatrixStack transform, int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i + x, this.field_147009_r + y, 45, 247, 15, 9);
    }

    public void drawFertilityInfo(MatrixStack transform, int fertility, int x, int textColor, int texOffset) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String fertilityString = fertility + " x";
        int stringWidth = this.getFontRenderer().func_78256_a(fertilityString);
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i + x + stringWidth + 2, this.field_147009_r + this.textLayout.getLineY() - 1, 60, 240 + texOffset, 12, 8);
        this.textLayout.drawLine(transform, fertilityString, x, textColor);
    }

    public WidgetManager getWidgetManager() {
        return this.widgetManager;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger(this.getHints());
    }

    public List<String> getHints() {
        IRootDefinition definition;
        ItemStack specimen = this.itemInventory.getSpecimen();
        if (!specimen.func_190926_b() && (definition = RootUtils.getRoot(specimen)).isPresent()) {
            IAlyzerPlugin alyzerPlugin = ((IForestrySpeciesRoot)definition.get()).getAlyzerPlugin();
            return alyzerPlugin.getHints();
        }
        return Collections.emptyList();
    }
}

