/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.climate.IClimatised;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.config.Config;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.elements.WindowGui;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.slots.ISlotTextured;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.render.ColourProperties;
import forestry.core.render.ForestryResource;
import forestry.energy.EnergyManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class GuiForestry<C extends Container>
extends ContainerScreen<C>
implements IGuiSizable {
    protected final C container;
    public final ResourceLocation textureFile;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected final LedgerManager ledgerManager = new LedgerManager(this);
    protected final TextLayoutHelper textLayout;
    protected final WindowGui<?> window = new WindowGui<GuiForestry>(this.field_146999_f, this.field_147000_g, this);

    protected GuiForestry(String texture, C container, PlayerInventory inv, ITextComponent title) {
        this(new ForestryResource(texture), container, inv, title);
    }

    protected GuiForestry(ResourceLocation texture, C container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.textureFile = texture;
        this.container = container;
        this.textLayout = new TextLayoutHelper(this, ColourProperties.INSTANCE);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int maxLedgerWidth = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.ledgerManager.setMaxWidth(maxLedgerWidth);
        this.ledgerManager.clear();
        this.window.init(this.field_147003_i, this.field_147009_r);
        this.addLedgers();
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        this.window.setSize(width, height);
        super.func_231158_b_(mc, width, height);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.window.updateClient();
    }

    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float partialTicks) {
        this.window.setMousePosition(mouseX, mouseY);
        this.func_230446_a_(transform);
        super.func_230430_a_(transform, mouseX, mouseY, partialTicks);
        this.func_230459_a_(transform, mouseX, mouseY);
    }

    protected abstract void addLedgers();

    protected final void addErrorLedger(IErrorSource errorSource) {
        this.ledgerManager.add(errorSource);
    }

    protected final void addErrorLedger(IErrorLogicSource errorSource) {
        this.ledgerManager.add(errorSource.getErrorLogic());
    }

    protected final void addClimateLedger(IClimatised climatised) {
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, climatised));
    }

    protected final void addPowerLedger(EnergyManager energyManager) {
        if (Config.enableEnergyStat) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, energyManager));
        }
    }

    protected final void addHintLedger(String hintsKey) {
        if (Config.enableHints) {
            List hints = Config.hints.get((Object)hintsKey);
            this.addHintLedger(hints);
        }
    }

    protected final void addHintLedger(List<String> hints) {
        if (Config.enableHints && !hints.isEmpty()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, hints));
        }
    }

    protected final void addOwnerLedger(IOwnedTile ownedTile) {
        this.ledgerManager.add(new OwnerLedger(this.ledgerManager, ownedTile));
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.ledgerManager.onClose();
    }

    public ColourProperties getFontColor() {
        return ColourProperties.INSTANCE;
    }

    public FontRenderer getFontRenderer() {
        return this.field_230706_i_.field_71466_p;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.ledgerManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        this.widgetManager.handleMouseClicked(mouseX, mouseY, mouseButton);
        if (this.window.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.widgetManager.handleMouseRelease(mouseX, mouseY, mouseButton) || this.window.onMouseReleased(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.window.onMouseMove(mouseX, mouseY);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double oldMouseX, double oldMouseY) {
        if (this.window.onMouseDrag(mouseX, mouseY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, oldMouseX, oldMouseY);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.window.onKeyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public boolean func_223281_a_(int key, int scanCode, int modifiers) {
        if (this.window.onKeyReleased(key, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(key, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.window.onCharTyped(codePoint, modifiers)) {
            return true;
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double deltaWheel) {
        super.func_231043_a_(mouseX, mouseY, deltaWheel);
        if (deltaWheel != 0.0 && this.window.onMouseScrolled(mouseX, mouseY, deltaWheel)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, deltaWheel);
    }

    @Nullable
    public FluidStack getFluidStackAtPosition(double mouseX, double mouseY) {
        for (Widget widget : this.widgetManager.getWidgets()) {
            TankWidget tankWidget;
            IFluidTank tank;
            if (!(widget instanceof TankWidget) || !widget.isMouseOver(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r) || (tank = (tankWidget = (TankWidget)widget).getTank()) == null) continue;
            return tank.getFluid();
        }
        return null;
    }

    @Nullable
    protected Slot getSlotAtPosition(double mouseX, double mouseY) {
        for (int k = 0; k < ((Container)this.container).field_75151_b.size(); ++k) {
            Slot slot = (Slot)((Container)this.container).field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, double mouseX, double mouseY) {
        return this.func_195359_a(par1Slot.field_75223_e, par1Slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return !this.window.isMouseOver(mouseX - (double)guiLeft, mouseY - (double)guiTop) && super.func_195361_a(mouseX, mouseY, guiLeft, guiTop, mouseButton);
    }

    public void func_238746_a_(MatrixStack transform, Slot slot) {
        if (slot instanceof ISlotTextured) {
            ResourceLocation location;
            ISlotTextured textured = (ISlotTextured)slot;
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b() && slot.func_111238_b() && (location = textured.getBackgroundTexture()) != null) {
                TextureAtlasSprite sprite = textured.getBackgroundAtlas().apply(location);
                this.field_230706_i_.func_110434_K().func_110577_a(sprite.func_229241_m_().func_229223_g_());
                GuiForestry.func_238470_a_((MatrixStack)transform, (int)slot.field_75223_e, (int)slot.field_75221_f, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)sprite);
            }
        }
        super.func_238746_a_(transform, slot);
    }

    protected void func_230451_b_(MatrixStack transform, int mouseX, int mouseY) {
        this.ledgerManager.drawTooltips(transform, mouseX, mouseY);
        if (this.field_213127_e.func_70445_o().func_190926_b()) {
            GuiUtil.drawToolTips(transform, this, this.widgetManager.getWidgets(), mouseX, mouseY);
            GuiUtil.drawToolTips(transform, this, this.field_230710_m_, mouseX, mouseY);
            GuiUtil.drawToolTips(transform, this, ((Container)this.container).field_75151_b, mouseX, mouseY);
            this.window.drawTooltip(transform, mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(transform);
        this.widgetManager.updateWidgets(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawWidgets(transform);
        RenderSystem.popMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.window.draw(transform, mouseX, mouseY);
        this.bindTexture(this.textureFile);
    }

    protected void drawBackground(MatrixStack transform) {
        this.bindTexture(this.textureFile);
        this.func_238474_b_(transform, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawWidgets(MatrixStack transform) {
        this.ledgerManager.drawLedgers(transform);
        this.widgetManager.drawWidgets(transform);
    }

    protected void bindTexture(ResourceLocation texturePath) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(texturePath);
    }

    @Override
    public int getSizeX() {
        return this.field_146999_f;
    }

    @Override
    public int getSizeY() {
        return this.field_147000_g;
    }

    @Override
    public int getGuiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public Minecraft getGameInstance() {
        return (Minecraft)Preconditions.checkNotNull((Object)this.field_230706_i_);
    }

    public List<Rectangle2d> getExtraGuiAreas() {
        return this.ledgerManager.getLedgerAreas();
    }

    public TextLayoutHelper getTextLayout() {
        return this.textLayout;
    }
}

