/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class GuiTextBox
extends TextFieldWidget {
    private static final int enabledColor = 0xE0E0E0;
    private static final int disabledColor = 0x707070;
    private final FontRenderer fontRenderer;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private int lineScroll = 0;
    private int maxLines = 0;

    public GuiTextBox(FontRenderer fontRenderer, int startX, int startY, int width, int height) {
        super(fontRenderer, startX, startY, width, height, null);
        this.fontRenderer = fontRenderer;
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
    }

    private int getLineScrollOffset() {
        return 0;
    }

    public void advanceLine() {
        if (this.lineScroll < this.maxLines - 1) {
            ++this.lineScroll;
        }
    }

    public void regressLine() {
        if (this.lineScroll > 0) {
            --this.lineScroll;
        }
    }

    public boolean moreLinesAllowed() {
        int n = this.fontRenderer.func_238425_b_((ITextProperties)new StringTextComponent(this.getCursoredText()), this.width).size();
        this.fontRenderer.getClass();
        return n * 9 < this.height;
    }

    private String getCursoredText() {
        if (!this.func_230999_j_()) {
            return this.func_146179_b();
        }
        int cursorPos = this.func_146198_h() - this.getLineScrollOffset();
        String text = this.func_146179_b();
        if (cursorPos < 0) {
            return text;
        }
        if (cursorPos >= text.length()) {
            return text + "_";
        }
        return text.substring(0, cursorPos) + "_" + text.substring(cursorPos);
    }

    private void drawScrolledSplitString(MatrixStack transform, ITextComponent text, int startX, int startY, int width, int textColour) {
        List lines = this.fontRenderer.func_238425_b_((ITextProperties)text, width);
        this.maxLines = lines.size();
        int count = 0;
        int lineY = startY;
        for (IReorderingProcessor line : lines) {
            if (count < this.lineScroll) {
                ++count;
                continue;
            }
            this.fontRenderer.getClass();
            if (lineY + 9 - startY > this.height) break;
            this.fontRenderer.func_238422_b_(transform, line, (float)startX, (float)lineY, textColour);
            this.fontRenderer.getClass();
            lineY += 9;
            ++count;
        }
    }
}

