/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.elements.WindowGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiWindow
extends Screen
implements IGuiSizable {
    protected final WindowGui window;
    protected final int xSize;
    protected final int ySize;
    protected int guiLeft;
    protected int guiTop;

    public GuiWindow(int xSize, int ySize, ITextComponent title) {
        super(title);
        this.xSize = xSize;
        this.ySize = ySize;
        this.window = new WindowGui<GuiWindow>(xSize, ySize, this);
        this.addElements();
    }

    protected void addElements() {
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231023_e_() {
        this.window.updateClient();
    }

    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float partialTicks) {
        this.window.setMousePosition(mouseX, mouseY);
        super.func_230430_a_(transform, mouseX, mouseY, partialTicks);
        this.window.draw(transform, mouseX, mouseY);
    }

    protected void drawTooltips(MatrixStack transform, int mouseY, int mouseX) {
        PlayerInventory playerInv = this.field_230706_i_.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o().func_190926_b()) {
            GuiUtil.drawToolTips(transform, this, this.field_230705_e_, mouseX, mouseY);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            this.window.drawTooltip(transform, mouseX, mouseY);
            RenderSystem.popMatrix();
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.window.init(this.guiLeft, this.guiTop);
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        this.window.setSize(width, height);
        super.func_231158_b_(mc, width, height);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.window.onMouseMove(mouseX, mouseY);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double oldMouseX, double oldMouseY) {
        if (this.window.onMouseDrag(mouseX, mouseY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, oldMouseX, oldMouseY);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.field_230706_i_.func_147108_a(null);
            if (this.field_230706_i_.field_71462_r == null) {
                this.field_230706_i_.func_213228_a(true);
            }
        }
        if (this.window.onKeyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public boolean func_223281_a_(int key, int scanCode, int modifiers) {
        if (this.window.onKeyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(key, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.window.onCharTyped(codePoint, modifiers)) {
            return true;
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.window.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.window.onMouseReleased(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double deltaWheel) {
        if (deltaWheel != 0.0 && this.window.onMouseScrolled(mouseX, mouseY, deltaWheel)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, deltaWheel);
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    @Override
    public Minecraft getGameInstance() {
        return (Minecraft)Preconditions.checkNotNull((Object)this.field_230706_i_);
    }
}

