/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.buttons;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.IToolTipProvider;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.buttons.IButtonTextureSet;
import forestry.core.render.ForestryResource;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiBetterButton
extends Button
implements IToolTipProvider {
    public static final ResourceLocation TEXTURE = new ForestryResource("textures/gui/buttons.png");
    protected IButtonTextureSet texture;
    @Nullable
    private ToolTip toolTip;
    private boolean useTexWidth = false;

    public GuiBetterButton(int x, int y, IButtonTextureSet texture) {
        this(x, y, texture, b -> {});
    }

    public GuiBetterButton(int x, int y, IButtonTextureSet texture, Button.IPressable handler) {
        super(x, y, texture.getWidth(), texture.getHeight(), StringTextComponent.field_240750_d_, handler);
        this.texture = texture;
        this.useTexWidth = true;
    }

    public GuiBetterButton setTexture(IButtonTextureSet texture) {
        this.texture = texture;
        this.field_230688_j_ = texture.getWidth();
        this.field_230689_k_ = texture.getHeight();
        return this;
    }

    public GuiBetterButton setUseTextureWidth() {
        this.useTexWidth = true;
        return this;
    }

    public GuiBetterButton setGuiWidth(int width) {
        this.field_230688_j_ = width;
        this.useTexWidth = false;
        return this;
    }

    public GuiBetterButton setLabel(String label) {
        this.func_238482_a_((ITextComponent)new StringTextComponent(label));
        return this;
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    public int func_238483_d_() {
        return this.texture.getHeight();
    }

    public int getTextColor(boolean mouseOver) {
        if (!this.field_230693_o_) {
            return -6250336;
        }
        if (mouseOver) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public boolean isMouseOverButton(double mouseX, double mouseY) {
        return mouseX >= (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseX < (double)(this.field_230690_l_ + this.func_230998_h_()) && mouseY < (double)(this.field_230691_m_ + this.func_238483_d_());
    }

    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_230694_p_) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.texture.getX();
        int yOffset = this.texture.getY();
        int h = this.texture.getHeight();
        int w = this.texture.getWidth();
        this.field_230692_n_ = this.isMouseOverButton(mouseX, mouseY);
        int hoverState = this.func_230989_a_(this.func_230449_g_());
        if (this.useTexWidth) {
            this.func_238474_b_(transform, this.field_230690_l_, this.field_230691_m_, xOffset, yOffset + hoverState * h, w, h);
        } else {
            this.func_238474_b_(transform, this.field_230690_l_, this.field_230691_m_, xOffset, yOffset + hoverState * h, this.field_230688_j_ / 2, h);
            this.func_238474_b_(transform, this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_, xOffset + w - this.field_230688_j_ / 2, yOffset + hoverState * h, this.field_230688_j_ / 2, h);
        }
        if (this.func_230458_i_() != StringTextComponent.field_240750_d_) {
            this.func_230431_b_(transform, mouseX, mouseY, partialTicks);
            GuiBetterButton.func_238472_a_((MatrixStack)transform, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.func_230998_h_() / 2), (int)(this.field_230691_m_ + (h - 8) / 2), (int)this.getTextColor(this.field_230692_n_));
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTip;
    }

    public void setToolTip(ToolTip tips) {
        this.toolTip = tips;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.field_230694_p_;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return this.isMouseOverButton(mouseX, mouseY);
    }

    @Override
    public boolean isHovering(double mouseX, double mouseY) {
        return this.func_231047_b_(mouseX, mouseY);
    }
}

