/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.Drawable;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.gui.elements.ElementBuilder;
import forestry.core.gui.elements.GuiElement;
import forestry.core.utils.SoundUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ButtonElement
extends GuiElement {
    private final Consumer<ButtonElement> onClicked;
    private final Drawable[] textures;
    private boolean enabled = true;

    public ButtonElement(Builder builder) {
        super(builder);
        Preconditions.checkNotNull((Object)builder.onClicked, (Object)"No action was defined for this button.");
        Preconditions.checkArgument((builder.textures[0] != null && builder.textures[1] != null && builder.textures[2] != null ? 1 : 0) != 0, (Object)"The button is missing some textures.");
        this.onClicked = builder.onClicked;
        this.textures = builder.textures;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.enabled) {
            return false;
        }
        this.onPressed();
        SoundUtil.playButtonClick();
        return true;
    }

    @Override
    public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        RenderSystem.enableAlphaTest();
        boolean mouseOver = this.isMouseOver();
        int hoverState = this.getTextureIndex(mouseOver);
        Drawable drawable = this.textures[hoverState];
        drawable.draw(transform, 0, 0);
        RenderSystem.disableAlphaTest();
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected int getTextureIndex(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    public void onPressed() {
        this.onClicked.accept(this);
    }

    public static class Builder
    extends ElementBuilder<Builder, ButtonElement> {
        private final Drawable[] textures = new Drawable[3];
        @Nullable
        private Consumer<ButtonElement> onClicked;

        public Builder action(@Nullable Consumer<ButtonElement> onClicked) {
            this.onClicked = onClicked;
            return this;
        }

        public Builder textures(StandardButtonTextureSets textureSets) {
            this.size(textureSets.getWidth(), textureSets.getHeight());
            for (int i = 0; i < 3; ++i) {
                this.textures[i] = new Drawable(textureSets.getTexture(), textureSets.getX(), textureSets.getY() + textureSets.getHeight() * i, textureSets.getWidth(), textureSets.getHeight());
            }
            return this;
        }

        public Builder textures(Drawable drawable) {
            this.size(drawable.uWidth, drawable.vHeight);
            for (int i = 0; i < 3; ++i) {
                this.textures[i] = new Drawable(drawable.textureLocation, drawable.u, drawable.v + drawable.vHeight * i, drawable.uWidth, drawable.vHeight);
            }
            return this;
        }

        public Builder textures(Drawable disabledDrawable, Drawable enabledDrawable) {
            return this.textures(disabledDrawable, enabledDrawable, enabledDrawable);
        }

        public Builder textures(Drawable disabledDrawable, Drawable enabledDrawable, Drawable mouseOverDrawable) {
            this.size(disabledDrawable.uWidth, disabledDrawable.vHeight);
            this.textures[0] = disabledDrawable;
            this.textures[1] = enabledDrawable;
            this.textures[2] = mouseOverDrawable;
            return this;
        }

        @Override
        public ButtonElement create() {
            return new ButtonElement(this);
        }
    }
}

