/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.base.Preconditions;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.gatgets.DatabaseMode;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import forestry.core.utils.Translator;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class DatabaseElement
extends ContainerElement {
    private DatabaseMode mode = DatabaseMode.ACTIVE;
    @Nullable
    private IIndividual individual;
    private int secondColumn = 0;
    private int thirdColumn = 0;

    public DatabaseElement(int width) {
        this.setSize(width, -1);
        this.setLayout(FlexLayout.vertical(0));
        this.secondColumn = width / 2;
    }

    public void init(DatabaseMode mode, IIndividual individual, int secondColumn, int thirdColumn) {
        this.mode = mode;
        this.individual = individual;
        this.secondColumn = secondColumn;
        this.thirdColumn = thirdColumn;
    }

    @Nullable
    public IIndividual getIndividual() {
        return this.individual;
    }

    public IGenome getGenome() {
        Preconditions.checkNotNull((Object)this.individual, (Object)"Database Element has not been initialised.");
        return this.individual.getGenome();
    }

    public void addFertilityLine(String chromosomeName, IChromosomeType chromosome, int texOffset) {
        IGenome genome = this.getGenome();
        IAllele activeAllele = genome.getActiveAllele(chromosome);
        IAllele inactiveAllele = genome.getInactiveAllele(chromosome);
        if (this.mode == DatabaseMode.BOTH) {
            if (!(activeAllele instanceof IAlleleValue) || !(inactiveAllele instanceof IAlleleValue)) {
                return;
            }
            this.addLine(chromosomeName, GuiElementFactory.INSTANCE.createFertilityInfo((IAlleleValue)activeAllele, texOffset), GuiElementFactory.INSTANCE.createFertilityInfo((IAlleleValue)inactiveAllele, texOffset));
        } else {
            IAllele allele;
            boolean active = this.mode == DatabaseMode.ACTIVE;
            IAllele iAllele = allele = active ? activeAllele : inactiveAllele;
            if (!(allele instanceof IAlleleValue)) {
                return;
            }
            this.addLine(chromosomeName, GuiElementFactory.INSTANCE.createFertilityInfo((IAlleleValue)allele, texOffset));
        }
    }

    public void addToleranceLine(IChromosomeType chromosome) {
        IAllele allele = this.getGenome().getActiveAllele(chromosome);
        if (!(allele instanceof IAlleleValue)) {
            return;
        }
        this.addLine("  " + Translator.translateToLocal("for.gui.tolerance"), GuiElementFactory.INSTANCE.createToleranceInfo((IAlleleValue)allele));
    }

    public void addMutation(int x, int y, int width, int height, IMutation mutation, IAllele species, IBreedingTracker breedingTracker) {
        ContainerElement element = GuiElementFactory.INSTANCE.createMutation(x, y, width, height, mutation, species, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    public void addMutationResultant(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        GuiElement element = GuiElementFactory.INSTANCE.createMutationResultant(x, y, width, height, mutation, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    public void addLine(String firstText, String secondText, boolean dominant) {
        this.addLine(firstText, secondText, GuiElementFactory.INSTANCE.guiStyle, GuiElementFactory.INSTANCE.getStateStyle(dominant));
    }

    public void addLine(String leftText, Function<Boolean, String> toText, boolean dominant) {
        if (this.mode == DatabaseMode.BOTH) {
            this.addLine(leftText, toText.apply(true), toText.apply(false), dominant, dominant);
        } else {
            this.addLine(leftText, toText.apply(this.mode == DatabaseMode.ACTIVE), dominant);
        }
    }

    public void addLine(String leftText, Function<Boolean, String> toText, IChromosomeType chromosome) {
        IGenome genome = this.getGenome();
        IAllele activeAllele = genome.getActiveAllele(chromosome);
        IAllele inactiveAllele = genome.getInactiveAllele(chromosome);
        if (this.mode == DatabaseMode.BOTH) {
            this.addLine(leftText, toText.apply(true), toText.apply(false), activeAllele.isDominant(), inactiveAllele.isDominant());
        } else {
            boolean active = this.mode == DatabaseMode.ACTIVE;
            IAllele allele = active ? activeAllele : inactiveAllele;
            this.addLine(leftText, toText.apply(active), allele.isDominant());
        }
    }

    public void addLine(String firstText, String secondText, String thirdText, boolean secondDominant, boolean thirdDominant) {
    }

    public final void addLine(String chromosomeName, IChromosomeType chromosome) {
        this.addLine(chromosomeName, (A allele, Boolean b) -> allele.getDisplayName().getString(), chromosome);
    }

    public void addLine(String firstText, String secondText, Style firstStyle, Style secondStyle) {
        ContainerElement first = this.addSplitText(this.preferredSize.width, firstText, firstStyle);
        ContainerElement second = this.addSplitText(this.preferredSize.width, secondText, secondStyle);
        this.addLine(first, (GuiElement)second);
    }

    private ContainerElement addSplitText(int width, String text, Style style) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ContainerElement vertical = GuiElementFactory.vertical(width, 0);
        for (IReorderingProcessor splitText : fontRenderer.func_238425_b_((ITextProperties)new StringTextComponent(text), width)) {
            vertical.label(splitText).setStyle(style);
        }
        return vertical;
    }

    private void addLine(String chromosomeName, GuiElement right) {
        int center = this.preferredSize.width / 2;
        ContainerElement first = this.addSplitText(center, chromosomeName, GuiElementFactory.INSTANCE.guiStyle);
        this.addLine(first, right);
    }

    private void addLine(String chromosomeName, GuiElement second, GuiElement third) {
        int center = this.preferredSize.width / 2;
        ContainerElement first = this.addSplitText(center, chromosomeName, GuiElementFactory.INSTANCE.guiStyle);
        this.addLine(first, second, third);
    }

    private void addLine(GuiElement first, GuiElement second, GuiElement third) {
        ContainerElement panel = this.pane(this.preferredSize.width, -1);
        first.setAlign(Alignment.MIDDLE_LEFT);
        second.setAlign(Alignment.MIDDLE_LEFT);
        third.setAlign(Alignment.MIDDLE_LEFT);
        panel.add(first);
        panel.add(second);
        panel.add(third);
        second.setXPosition(this.secondColumn);
        third.setXPosition(this.thirdColumn);
    }

    private void addLine(GuiElement first, GuiElement second) {
        ContainerElement panel = this.pane(this.preferredSize.width, -1);
        first.setAlign(Alignment.MIDDLE_LEFT);
        second.setAlign(Alignment.MIDDLE_LEFT);
        panel.add(first);
        panel.add(second);
        second.setXPosition(this.secondColumn);
    }

    public <A extends IAllele> void addLine(String chromosomeName, BiFunction<A, Boolean, String> toText, IChromosomeType chromosome) {
        this.addAlleleRow(chromosomeName, toText, chromosome, null);
    }

    public <A extends IAllele> void addLine(String chromosomeName, BiFunction<A, Boolean, String> toText, IChromosomeType chromosome, boolean dominant) {
        this.addAlleleRow(chromosomeName, toText, chromosome, dominant);
    }

    private <A extends IAllele> void addAlleleRow(String chromosomeName, BiFunction<A, Boolean, String> toString, IChromosomeType chromosome, @Nullable Boolean dominant) {
        IGenome genome = this.getGenome();
        IAllele activeAllele = genome.getActiveAllele(chromosome);
        IAllele inactiveAllele = genome.getInactiveAllele(chromosome);
        if (this.mode == DatabaseMode.BOTH) {
            this.addLine(chromosomeName, toString.apply(activeAllele, true), toString.apply(inactiveAllele, false), dominant != null ? dominant.booleanValue() : activeAllele.isDominant(), dominant != null ? dominant.booleanValue() : inactiveAllele.isDominant());
        } else {
            boolean active = this.mode == DatabaseMode.ACTIVE;
            IAllele allele = active ? activeAllele : inactiveAllele;
            this.addLine(chromosomeName, toString.apply(allele, active), dominant != null ? dominant.booleanValue() : allele.isDominant());
        }
    }

    public void addSpeciesLine(String firstText, @Nullable String secondText, IChromosomeType chromosome) {
    }
}

