/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.gatgets.IDatabasePlugin;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.api.genetics.gatgets.IGeneticAnalyzer;
import forestry.api.genetics.gatgets.IGeneticAnalyzerProvider;
import forestry.core.gui.Drawable;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.gui.elements.AbstractItemElement;
import forestry.core.gui.elements.ButtonElement;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GeneticAnalyzerTabs;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.ScrollBarElement;
import forestry.core.gui.elements.ScrollableElement;
import forestry.core.gui.elements.Window;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import genetics.api.individual.IIndividual;
import genetics.api.root.IRootDefinition;
import genetics.utils.RootUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GeneticAnalyzer
extends ContainerElement
implements IGeneticAnalyzer,
IScrollable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/analyzer_screen.png");
    public static final Drawable SCROLLBAR_BACKGROUND = new Drawable(TEXTURE, 202, 0, 3, 142);
    public static final Drawable SCROLLBAR_SLIDER = new Drawable(TEXTURE, 205, 0, 3, 5);
    public static final Drawable SELECTION_BAR = new Drawable(TEXTURE, 70, 166, 107, 32);
    public static final Drawable ANALYZER_BUTTON = new Drawable(TEXTURE, 163, 40, 22, 25);
    private final IGeneticAnalyzerProvider provider;
    private final ScrollBarElement scrollBar;
    private final ScrollableElement scrollable;
    private final DatabaseElement scrollableContent;
    private final GeneticAnalyzerTabs tabs;
    private final GuiElement itemElement;
    private final ButtonElement leftButton;
    private final ButtonElement rightButton;
    private final ButtonElement analyzeButton;
    private int selectedSlot = -1;

    public GeneticAnalyzer(Window window, int xPos, int yPos, boolean rightBoarder, final IGeneticAnalyzerProvider provider) {
        this.setSize(189 + (rightBoarder ? 6 : 0), 194);
        this.setPos(xPos - (rightBoarder ? 6 : 0), yPos);
        window.add(this);
        this.provider = provider;
        this.drawable(32, 0, new Drawable(TEXTURE, 0, 0, 163 + (rightBoarder ? 0 : -6), 166));
        this.scrollable = new ScrollableElement();
        this.scrollable.setPreferredBounds(42, 8, 145, 150);
        this.add(this.scrollable);
        this.scrollableContent = new DatabaseElement(145);
        this.scrollableContent.setPos(0, 0);
        this.scrollable.addContent(this.scrollableContent);
        this.scrollBar = new ScrollBarElement(SCROLLBAR_BACKGROUND, false, SCROLLBAR_SLIDER);
        this.scrollBar.setPos(this.preferredSize.width - 10 - (rightBoarder ? 6 : 0), 12);
        this.scrollBar.hide();
        this.add(this.scrollBar);
        this.tabs = new GeneticAnalyzerTabs(this);
        this.tabs.setPos(0, 5);
        this.add(this.tabs);
        ContainerElement container = this.pane();
        container.setPos((this.preferredSize.width + 32 - GeneticAnalyzer.SELECTION_BAR.uWidth) / 2, 162);
        this.itemElement = container.drawable(SELECTION_BAR);
        this.leftButton = container.add(((ButtonElement.Builder)new ButtonElement.Builder().pos(this.itemElement.getX() + 30, this.itemElement.getY() + 9)).textures(StandardButtonTextureSets.LEFT_BUTTON).action(button -> this.subtract()).create());
        this.rightButton = container.add(((ButtonElement.Builder)new ButtonElement.Builder().pos(this.itemElement.getX() + 64, this.itemElement.getY() + 9)).textures(StandardButtonTextureSets.RIGHT_BUTTON).action(button -> this.add()).create());
        this.analyzeButton = container.add(((ButtonElement.Builder)new ButtonElement.Builder().pos(this.itemElement.getX() + 80, this.itemElement.getY() + 2)).textures(ANALYZER_BUTTON).action(button -> NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, provider.getSelectedSlot(this.selectedSlot)))).create());
        container.add(new AbstractItemElement(this.itemElement.getX() + 44, this.itemElement.getY() + 9){

            @Override
            protected ItemStack getStack() {
                return provider.getSpecimen(GeneticAnalyzer.this.selectedSlot);
            }
        });
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 264 || keyCode == 262) && this.rightButton.isEnabled()) {
            this.rightButton.onPressed();
            return true;
        }
        if ((keyCode == 265 || keyCode == 263) && this.leftButton.isEnabled()) {
            this.leftButton.onPressed();
            return true;
        }
        if (keyCode == 257 && this.analyzeButton.isEnabled()) {
            this.analyzeButton.onPressed();
            return true;
        }
        return false;
    }

    @Override
    public void init() {
        this.leftButton.setEnabled(this.canSubtract());
        this.rightButton.setEnabled(this.canAdd());
        this.updateSelected();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public IGeneticAnalyzerProvider getProvider() {
        return this.provider;
    }

    @Override
    public GuiElement getItemElement() {
        return this.itemElement;
    }

    @Override
    public void update() {
        Optional optionalIndividual;
        IForestrySpeciesRoot root;
        IDatabasePlugin databasePlugin;
        if (!this.isVisible()) {
            return;
        }
        ItemStack stack = this.provider.getSpecimen(this.selectedSlot);
        IRootDefinition definition = RootUtils.getRoot(stack);
        if (definition.isPresent() && (databasePlugin = (root = (IForestrySpeciesRoot)definition.get()).getSpeciesPlugin()) != null && (optionalIndividual = root.create(stack)).isPresent()) {
            IIndividual individual = (IIndividual)optionalIndividual.get();
            if (individual.isAnalyzed()) {
                this.tabs.setPlugin(databasePlugin);
                IDatabaseTab<?> tab = this.tabs.getSelected();
                this.scrollableContent.clear();
                this.scrollableContent.init(tab.getMode(), individual, this.scrollableContent.getWidth() / 2, 0);
                tab.createElements(this.scrollableContent, individual, stack);
                this.scrollableContent.forceLayout();
                int invisibleArea = this.scrollable.getInvisibleArea();
                if (invisibleArea > 0) {
                    this.scrollBar.setParameters(this, 0, invisibleArea, 1);
                    this.scrollBar.show();
                } else {
                    this.scrollBar.setValue(0);
                    this.scrollBar.hide();
                }
                return;
            }
            this.tabs.setPlugin(null);
        }
        this.scrollableContent.clear();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String key = "for.gui.portablealyzer.help";
        List lines = fontRenderer.func_238425_b_((ITextProperties)new TranslationTextComponent(key), this.scrollable.getPreferredSize().width);
        for (IReorderingProcessor text : lines) {
            this.scrollableContent.label(text);
        }
        this.scrollBar.hide();
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.isMouseOver();
    }

    @Override
    public void onScroll(int value) {
        this.scrollable.onScroll(value);
    }

    private boolean canAdd() {
        return this.selectedSlot + 1 < this.getSlotCount();
    }

    private boolean canSubtract() {
        int selectedSlot = this.selectedSlot - 1;
        return selectedSlot < this.getSlotCount() && selectedSlot >= 0;
    }

    public void add() {
        this.setSelectedSlot(this.selectedSlot + 1);
    }

    private void subtract() {
        this.setSelectedSlot(this.selectedSlot - 1);
    }

    private int getSlotCount() {
        return this.provider.getSlotCount();
    }

    @Override
    public void setSelectedSlot(int selectedSlot) {
        int oldSelected = this.selectedSlot;
        this.selectedSlot = selectedSlot;
        this.onSelection(selectedSlot, oldSelected != selectedSlot);
    }

    private void onSelection(int selectedSlot, boolean changed) {
        this.leftButton.setEnabled(this.canSubtract());
        this.rightButton.setEnabled(this.canAdd());
        if (changed) {
            this.update();
        }
        this.provider.onSelection(selectedSlot, changed);
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void updateSelected() {
        if (this.provider.onUpdateSelected()) {
            return;
        }
        int slotCount = this.getSlotCount();
        if (slotCount <= 0) {
            this.setSelectedSlot(-1);
            return;
        }
        if (slotCount > this.selectedSlot && this.selectedSlot != -1) {
            return;
        }
        this.setSelectedSlot(this.provider.getFirstSlot());
    }

    @Override
    public int getSelected() {
        return this.selectedSlot;
    }
}

