/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import forestry.api.genetics.gatgets.IDatabasePlugin;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.core.genetics.analyzer.AnalyzerTab;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.elements.GeneticAnalyzer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import forestry.core.utils.SoundUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class GeneticAnalyzerTabs
extends ContainerElement {
    private static final Drawable SELECTED_BACKGROUND = new Drawable(GeneticAnalyzer.TEXTURE, 0, 166, 35, 26);
    private static final Drawable UNSELECTED_BACKGROUND = new Drawable(GeneticAnalyzer.TEXTURE, 0, 192, 35, 26);
    @Nullable
    public IDatabasePlugin<?> databasePlugin;
    public final GeneticAnalyzer analyzer;
    private int selected = 0;

    public GeneticAnalyzerTabs(GeneticAnalyzer analyzer) {
        this.setSize(35, -1);
        this.setLayout(FlexLayout.vertical(2));
        this.analyzer = analyzer;
        IDatabaseTab<?>[] tabs = this.getTabs();
        for (int i = 0; i < 4; ++i) {
            IDatabaseTab<?> tab = tabs.length > i ? tabs[i] : null;
            this.add(new Tab(i, tab));
        }
    }

    private void select(int index) {
        this.selected = index;
    }

    public IDatabaseTab<?> getSelected() {
        GuiElement element = (GuiElement)((Object)this.elements.get(this.selected));
        if (!(element instanceof Tab) || !element.isVisible()) {
            return AnalyzerTab.ANALYZE;
        }
        return ((Tab)element).tab;
    }

    public void setPlugin(@Nullable IDatabasePlugin<?> plugin) {
        if (this.databasePlugin != plugin) {
            this.selected = 0;
            this.databasePlugin = plugin;
            IDatabaseTab<?>[] tabs = this.getTabs();
            for (int i = 0; i < this.elements.size(); ++i) {
                GuiElement element = (GuiElement)((Object)this.elements.get(i));
                if (!(element instanceof Tab)) continue;
                IDatabaseTab<?> tab = tabs.length > i ? tabs[i] : null;
                Tab tabElement = (Tab)element;
                tabElement.setTab(tab);
            }
        }
    }

    private IDatabaseTab<?>[] getTabs() {
        if (this.databasePlugin == null) {
            return new IDatabaseTab[]{AnalyzerTab.ANALYZE};
        }
        return this.databasePlugin.getTabs();
    }

    private class Tab
    extends GuiElement {
        private final int index;
        @Nullable
        public IDatabaseTab<?> tab;
        private ItemStack displayStack = ItemStack.field_190927_a;

        public Tab(@Nullable int index, IDatabaseTab<?> tab) {
            this.setSize(35, 26);
            this.setTab(tab);
            this.index = index;
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (!this.isVisible()) {
                return false;
            }
            GeneticAnalyzerTabs.this.select(this.index);
            SoundUtil.playButtonClick();
            GeneticAnalyzerTabs.this.analyzer.update();
            return true;
        }

        @Override
        public boolean canMouseOver() {
            return true;
        }

        @Override
        public boolean isVisible() {
            return this.tab != null;
        }

        public void setTab(@Nullable IDatabaseTab<?> tab) {
            this.tab = tab;
            this.displayStack = tab != null ? tab.getIconStack() : ItemStack.field_190927_a;
        }

        @Override
        public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
            Drawable background;
            if (!this.isVisible()) {
                return;
            }
            int x = 0;
            Drawable drawable = background = GeneticAnalyzerTabs.this.selected == this.index ? SELECTED_BACKGROUND : UNSELECTED_BACKGROUND;
            if (GeneticAnalyzerTabs.this.selected != this.index) {
                x += 2;
            }
            background.draw(transform, 0, x);
            if (!this.displayStack.func_190926_b()) {
                GlStateManager.func_227623_K_();
                GuiUtil.drawItemStack(Minecraft.func_71410_x().field_71466_p, this.displayStack, x + 9, 5);
                RenderHelper.func_74518_a();
            }
        }
    }
}

