/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.ActionConfig;
import forestry.core.gui.elements.ActionType;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.Window;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.widgets.IScrollable;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;

public class ScrollBarElement
extends ContainerElement {
    private final GuiElement slider;
    private boolean isScrolling;
    private boolean wasClicked;
    private boolean vertical = false;
    private int currentValue;
    private final ContainerElement interactionField;
    private int initialMouseClick;
    @Nullable
    private IScrollable listener;
    private int minValue;
    private int maxValue;
    private int step;
    private boolean initialised = false;
    private boolean mouseDown = false;

    public ScrollBarElement(Drawable sliderTexture) {
        this.interactionField = this.add(new ContainerElement());
        this.interactionField.setSize(this.preferredSize.width, this.preferredSize.height);
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.slider = this.interactionField.drawable(sliderTexture);
        this.addListeners();
    }

    public ScrollBarElement(Drawable backgroundTexture, boolean hasBorder, Drawable sliderTexture) {
        this.setSize(backgroundTexture.uWidth, backgroundTexture.vHeight);
        int offset = hasBorder ? 1 : 0;
        this.interactionField = new ContainerElement();
        this.interactionField.setPreferredBounds(offset, offset, hasBorder ? this.preferredSize.width - 2 : this.preferredSize.width, hasBorder ? this.preferredSize.height - 2 : this.preferredSize.height);
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.drawable(backgroundTexture);
        this.slider = this.interactionField.drawable(sliderTexture);
        this.add(this.interactionField);
        this.addListeners();
    }

    @Override
    public GuiElement setPreferredBounds(int xPos, int yPos, int width, int height) {
        this.interactionField.setSize(width, height);
        return super.setPreferredBounds(xPos, yPos, width, height);
    }

    protected void addListeners() {
    }

    @Override
    protected ActionConfig.Builder buildActions(ActionConfig.Builder builder) {
        return builder.all(ActionType.PRESSED, ActionType.RELEASED, ActionType.SCROLLED);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.mouseDown = true;
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.mouseDown = false;
        return false;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.listener == null || this.listener.isFocused((int)mouseX, (int)mouseY) || this.isMouseOver()) {
            if (dWheel > 0.0) {
                this.setValue(this.currentValue - this.step);
            } else if (dWheel < 0.0) {
                this.setValue(this.currentValue + this.step);
            }
        }
        return false;
    }

    public ScrollBarElement setVertical() {
        this.vertical = true;
        return this;
    }

    public ScrollBarElement setParameters(IScrollable listener, int minValue, int maxValue, int step) {
        this.listener = listener;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        if (this.initialised) {
            this.setValue(this.currentValue);
        }
        return this;
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }

    public int getValue() {
        return MathHelper.func_76125_a((int)this.currentValue, (int)this.minValue, (int)this.maxValue);
    }

    public ScrollBarElement setValue(int value) {
        this.initialised = true;
        int oldValue = this.currentValue;
        this.currentValue = MathHelper.func_76125_a((int)value, (int)this.minValue, (int)this.maxValue);
        if (oldValue == this.currentValue) {
            return this;
        }
        if (this.listener != null) {
            this.listener.onScroll(this.currentValue);
        }
        if (this.vertical) {
            int offset = value >= this.maxValue ? this.interactionField.getWidth() - this.slider.getWidth() : (value <= this.minValue ? 0 : (int)((float)(this.currentValue - this.minValue) / (float)(this.maxValue - this.minValue) * (float)(this.interactionField.getWidth() - this.slider.getWidth())));
            this.slider.setXPosition(offset);
        } else {
            int offset = value >= this.maxValue ? this.interactionField.getHeight() - this.slider.getHeight() : (value <= this.minValue ? 0 : (int)((float)(this.currentValue - this.minValue) / (float)(this.maxValue - this.minValue) * (float)(this.interactionField.getHeight() - this.slider.getHeight())));
            this.slider.setYPosition(offset);
        }
        return this;
    }

    @Override
    public void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        Window window = this.getWindow();
        this.updateSlider(window.getRelativeMouseX(this.interactionField), window.getRelativeMouseY(this.interactionField));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawElement(transform, mouseX, mouseY);
    }

    private void updateSlider(int mouseX, int mouseY) {
        int pos;
        int n = pos = this.vertical ? mouseX - this.interactionField.getX() : mouseY - this.interactionField.getY();
        if (!this.mouseDown && this.wasClicked) {
            this.wasClicked = false;
        }
        if (!this.mouseDown && this.isScrolling) {
            this.isScrolling = false;
        }
        if (this.isScrolling) {
            int range = this.maxValue - this.minValue;
            float value = (float)(pos - this.initialMouseClick) / (float)(this.vertical ? this.interactionField.getWidth() - this.slider.getWidth() : this.interactionField.getHeight() - this.slider.getHeight());
            if ((value *= (float)range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
        } else if (this.slider.isMouseOver()) {
            if (this.mouseDown) {
                this.isScrolling = true;
                this.initialMouseClick = this.vertical ? pos - this.slider.getX() : pos - this.slider.getY();
            }
        } else if (this.mouseDown && !this.wasClicked && this.isMouseOver()) {
            int range = this.maxValue - this.minValue;
            float value = ((float)pos - (float)(this.vertical ? this.slider.getWidth() : this.slider.getHeight()) / 2.0f) / (float)(this.vertical ? this.interactionField.getWidth() - this.slider.getWidth() : this.interactionField.getHeight() - this.slider.getHeight());
            if ((value *= (float)range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
            this.wasClicked = true;
        }
    }
}

