/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiConstants;
import forestry.core.gui.elements.ActionConfig;
import forestry.core.gui.elements.ActionOrigin;
import forestry.core.gui.elements.ActionType;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DrawableElement;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.layouts.FreeLayout;
import forestry.core.gui.elements.layouts.Layout;
import forestry.core.gui.elements.layouts.LayoutHelper;
import forestry.core.gui.elements.text.LabelElement;
import forestry.core.utils.Log;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContainerElement
extends GuiElement {
    @Nullable
    protected Layout layout = FreeLayout.INSTANCE;
    protected final List<GuiElement> elements = new ArrayList<GuiElement>();
    protected boolean dirty;

    public <E extends GuiElement> E add(E element) {
        this.elements.add(element);
        element.setParent(this);
        this.markDirty();
        return element;
    }

    public <E extends GuiElement> E add(E element, Consumer<E> callback) {
        callback.accept(element);
        this.elements.add(element);
        element.setParent(this);
        this.markDirty();
        return element;
    }

    public <E extends GuiElement> E remove(E element) {
        this.elements.remove(element);
        this.getWindow().onRemove(element);
        this.markDirty();
        return element;
    }

    public ContainerElement add(GuiElement ... elements) {
        for (GuiElement element : elements) {
            this.add((E)element);
        }
        return this;
    }

    public ContainerElement remove(GuiElement ... elements) {
        for (GuiElement element : elements) {
            this.remove((E)element);
        }
        return this;
    }

    public ContainerElement add(Collection<GuiElement> elements) {
        elements.forEach(this::add);
        return this;
    }

    public ContainerElement remove(Collection<GuiElement> elements) {
        elements.forEach(this::remove);
        return this;
    }

    @Override
    public GuiElement setLocation(int xPos, int yPos) {
        this.markDirty();
        return super.setLocation(xPos, yPos);
    }

    @Override
    public GuiElement setPos(int x, int y) {
        this.markDirty();
        return super.setPos(x, y);
    }

    @Override
    public GuiElement setSize(int width, int height) {
        this.markDirty();
        return super.setSize(width, height);
    }

    @Override
    public void setAssignedBounds(Rectangle bounds) {
        this.markDirty();
        super.setAssignedBounds(bounds);
    }

    public ContainerElement setLayout(@Nullable Layout layout) {
        this.layout = layout;
        this.markDirty();
        return this;
    }

    public void forceLayout() {
        this.doLayout();
    }

    protected void doLayout() {
        if (this.layout == null || !this.dirty) {
            return;
        }
        if (this.bounds == null) {
            Log.error("Failed to layout container %s!", new Object[]{this});
            this.markClean();
            return;
        }
        this.layout.layoutContainer(this.bounds, this.elements);
        for (GuiElement element : this.elements) {
            element.afterLayout();
        }
        this.markClean();
    }

    @Override
    public Dimension getLayoutSize() {
        if (this.layout != null) {
            return this.layout.getLayoutSize(this);
        }
        return super.getLayoutSize();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void clear() {
        for (GuiElement element : new ArrayList<GuiElement>(this.elements)) {
            this.remove((E)element);
        }
        this.markClean();
    }

    public List<GuiElement> getElements() {
        return this.elements;
    }

    @Override
    protected void drawElement(MatrixStack transform, int mouseX, int mouseY) {
        this.doLayout();
        int mX = mouseX - this.getX();
        int mY = mouseY - this.getY();
        this.elements.forEach(element -> element.draw(transform, mX, mY));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        this.onUpdateClient();
        for (GuiElement widget : this.getElements()) {
            widget.updateClient();
        }
    }

    @Nullable
    public GuiElement getLastElement() {
        return this.elements.isEmpty() ? null : this.elements.get(this.elements.size() - 1);
    }

    public DrawableElement drawable(Drawable drawable) {
        return this.add((E)new DrawableElement(drawable));
    }

    public DrawableElement drawable(int x, int y, Drawable drawable) {
        return this.add((E)new DrawableElement(x, y, drawable));
    }

    public ItemElement item(int xPos, int yPos, ItemStack itemStack) {
        ItemElement element = new ItemElement(xPos, yPos, itemStack);
        this.add((E)element);
        return element;
    }

    public Style defaultStyle() {
        return GuiConstants.DEFAULT_STYLE;
    }

    public LabelElement label(ITextComponent component) {
        return new LabelElement.Builder(this::add, component).create();
    }

    public LabelElement label(IReorderingProcessor component) {
        return new LabelElement.Builder(this::add, component).create();
    }

    public LabelElement translated(String key, Object ... args) {
        return this.label((ITextComponent)new TranslationTextComponent(key, args));
    }

    public LabelElement.Builder labelLine(IFormattableTextComponent component) {
        return new LabelElement.Builder(this::add, component);
    }

    public LabelElement.Builder translatedLine(String key, Object ... args) {
        return this.labelLine((IFormattableTextComponent)new TranslationTextComponent(key, args));
    }

    public LabelElement.Builder labelLine(String text) {
        return this.labelLine((IFormattableTextComponent)new StringTextComponent(text));
    }

    public LabelElement label(String text) {
        return this.label(text, this.defaultStyle());
    }

    public LabelElement label(String text, Style style) {
        return this.label(text, Alignment.TOP_LEFT, style);
    }

    public LabelElement label(String text, Alignment align) {
        return this.label(text, align, this.defaultStyle());
    }

    public LabelElement label(String text, Alignment align, Style textStyle) {
        return this.label(text, 0, 0, -1, 12, align, textStyle);
    }

    public LabelElement label(String text, int x, int y, int width, int height, Alignment align, Style textStyle) {
        return new LabelElement.Builder(this::add, text, element -> element.setPos(x, y).setSize(width, height).setAlign(align)).fitText().setStyle(textStyle).create();
    }

    public ContainerElement vertical(int width, int spacing) {
        return this.add((E)GuiElementFactory.vertical(width, spacing));
    }

    public ContainerElement horizontal(int height, int spacing) {
        return this.add((E)GuiElementFactory.horizontal(height, spacing));
    }

    public ContainerElement pane() {
        return this.pane(0, 0, -1, -1);
    }

    public ContainerElement pane(int width, int height) {
        return this.pane(0, 0, width, height);
    }

    public ContainerElement pane(int xPos, int yPos, int width, int height) {
        return this.add(new ContainerElement(), (E container) -> container.setPreferredBounds(xPos, yPos, width, height));
    }

    public LayoutHelper layoutHelper(LayoutHelper.LayoutFactory layoutFactory, int width, int height) {
        return new LayoutHelper(layoutFactory, width, height, this);
    }

    @Override
    protected ActionConfig.Builder buildActions(ActionConfig.Builder builder) {
        return ActionConfig.allBuilder();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.callActions(mouseButton, ActionType.PRESSED, GuiElement::onMouseClicked);
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        return this.callActions(mouseButton, ActionType.RELEASED, GuiElement::onMouseReleased);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double dWheel) {
        return this.callActions(dWheel, ActionType.SCROLLED, GuiElement::onMouseScrolled);
    }

    @Override
    public void onMouseMove(double mouseX, double mouseY) {
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY) {
        return this.callActions(ActionType.DRAG_MOVE, GuiElement::onMouseDrag);
    }

    protected ActionOrigin getOrigin(GuiElement element, double mouseX, double mouseY) {
        boolean isTop = this.getWindow().isMouseOver(element);
        if (element.isMouseOver(mouseX, mouseY)) {
            return isTop ? ActionOrigin.SELF_TOP : ActionOrigin.SELF;
        }
        return ActionOrigin.ALL;
    }

    protected boolean canHandleAction(ActionType type) {
        return true;
    }

    protected boolean canReceiveAction(GuiElement element) {
        return element.isVisible() && element.isEnabled();
    }

    protected boolean hasOrigin(GuiElement element, double mouseX, double mouseY, ActionType type) {
        return element.hasOrigin(type, this.getOrigin(element, mouseX, mouseY));
    }

    protected <V> boolean callActions(V value, ActionType type, IMouseValueAction<V> action) {
        if (!this.canHandleAction(type)) {
            return false;
        }
        for (GuiElement element : this.elements) {
            double mX = this.getWindow().getRelativeMouseX(element);
            double mY = this.getWindow().getRelativeMouseY(element);
            if (!this.canReceiveAction(element) || !this.hasOrigin(element, mX, mY, type) || !action.handle(element, mX, mY, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean callActions(ActionType type, IMouseAction action) {
        if (!this.canHandleAction(type)) {
            return false;
        }
        for (GuiElement element : this.elements) {
            double mX = this.getWindow().getRelativeMouseX(element);
            double mY = this.getWindow().getRelativeMouseY(element);
            if (!this.canReceiveAction(element) || !this.hasOrigin(element, mX, mY, type) || !action.handle(element, mX, mY)) continue;
            return true;
        }
        return false;
    }

    private static interface IMouseAction {
        public boolean handle(GuiElement var1, double var2, double var4);
    }

    private static interface IMouseValueAction<V> {
        public boolean handle(GuiElement var1, double var2, double var4, V var6);
    }
}

