/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.text;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.gui.elements.text.LabelElement;
import java.awt.Dimension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.Style;

public abstract class AbstractTextElement<T, E extends AbstractTextElement<T, E>>
extends LabelElement {
    public static final FontRenderer FONT_RENDERER = Minecraft.func_71410_x().field_71466_p;
    public static final int DEFAULT_HEIGHT;
    protected T text;
    protected int originalWidth;
    protected boolean fitText;
    protected boolean shadow = false;

    public AbstractTextElement(T text) {
        this(0, 0, -1, DEFAULT_HEIGHT, text, true);
    }

    public AbstractTextElement(int xPos, int yPos, int width, int height, T text, boolean fitText) {
        super(xPos, yPos, width, height);
        this.originalWidth = width;
        this.text = text;
        this.setFitText(fitText);
    }

    public E setFitText(boolean fitText) {
        this.fitText = fitText;
        this.requestLayout();
        return (E)((Object)this);
    }

    public boolean isFitText() {
        return this.fitText;
    }

    public E setShadow(boolean value) {
        this.shadow = value;
        return (E)((Object)this);
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public Style getStyle() {
        if (this.text instanceof IFormattableTextComponent) {
            return ((IFormattableTextComponent)this.text).func_150256_b();
        }
        return Style.field_240709_b_;
    }

    public E setStyle(Style style) {
        if (this.text instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)this.text).func_230530_a_(style);
        }
        this.requestLayout();
        return (E)((Object)this);
    }

    public T getText() {
        return this.text;
    }

    public boolean setText(T value) {
        this.text = value;
        return true;
    }

    @Override
    public abstract void drawElement(MatrixStack var1, int var2, int var3);

    protected abstract int calcWidth(FontRenderer var1);

    @Override
    public Dimension getLayoutSize() {
        Dimension layoutSize = super.getLayoutSize();
        if (this.fitText || layoutSize.width < 0) {
            return new Dimension(this.calcWidth(FONT_RENDERER), layoutSize.height);
        }
        return layoutSize;
    }

    static {
        FONT_RENDERER.getClass();
        DEFAULT_HEIGHT = 9 + 3;
    }
}

