/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.text;

import com.google.common.base.Preconditions;
import forestry.api.core.tooltips.ITextInstance;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.text.ComponentText;
import forestry.core.gui.elements.text.ProcessorText;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public abstract class LabelElement
extends GuiElement {
    public LabelElement(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
    }

    public abstract LabelElement setStyle(Style var1);

    public abstract LabelElement setFitText(boolean var1);

    public abstract LabelElement setValue(Object var1);

    public static class Builder
    implements ITextInstance<Builder, Builder, LabelElement> {
        @Nullable
        private final Consumer<GuiElement> parentAdder;
        @Nullable
        private final Function<LabelElement, GuiElement> finisher;
        private final Object root;
        boolean fitText = false;
        boolean shadow = false;

        public Builder(Object root) {
            this(null, root, null);
        }

        public Builder(@Nullable Consumer<GuiElement> parentAdder, Object root) {
            this(parentAdder, root, null);
        }

        public Builder(@Nullable Consumer<GuiElement> parentAdder, Object root, @Nullable Function<LabelElement, GuiElement> finisher) {
            this.parentAdder = parentAdder;
            this.finisher = finisher;
            if (root instanceof String) {
                root = new StringTextComponent((String)root);
            }
            this.root = root;
        }

        @Override
        @Nullable
        public ITextComponent lastComponent() {
            if (this.root instanceof ITextComponent) {
                return (ITextComponent)this.root;
            }
            return null;
        }

        @Override
        public Builder add(ITextComponent line) {
            if (this.root instanceof IFormattableTextComponent) {
                ((IFormattableTextComponent)this.root).func_230529_a_(line);
            }
            return this;
        }

        @Override
        public Builder singleLine() {
            return this;
        }

        @Override
        public Builder cast() {
            return this;
        }

        @Override
        public LabelElement create() {
            Object element;
            Preconditions.checkNotNull((Object)this.root);
            if (this.root instanceof ITextComponent) {
                element = ((ComponentText)new ComponentText((ITextComponent)this.root).setFitText(this.fitText)).setShadow(this.shadow);
            } else if (this.root instanceof IReorderingProcessor) {
                element = ((ProcessorText)new ProcessorText((IReorderingProcessor)this.root).setFitText(this.fitText)).setShadow(this.shadow);
            } else {
                throw new IllegalStateException(String.format("Tried to create text widget with an invalid type of text '%s'", this.root.getClass()));
            }
            if (this.finisher != null) {
                element = (LabelElement)this.finisher.apply((LabelElement)((Object)element));
            }
            if (this.parentAdder != null) {
                this.parentAdder.accept((GuiElement)((Object)element));
            }
            return element;
        }

        public Builder fitText() {
            this.fitText = true;
            return this;
        }

        public Builder shadow() {
            this.shadow = true;
            return this;
        }

        public Builder setStyle(Style style) {
            if (this.root instanceof IFormattableTextComponent) {
                ((IFormattableTextComponent)this.root).func_230530_a_(style);
            }
            return this;
        }

        public Builder withStyle(Style style) {
            if (this.root instanceof IFormattableTextComponent) {
                ((IFormattableTextComponent)this.root).func_240703_c_(style);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

