/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.IErrorState;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ErrorLedger
extends Ledger {
    @Nullable
    private IErrorState state;

    public ErrorLedger(LedgerManager manager) {
        super(manager, "error", false);
        this.maxHeight = 72;
    }

    public void setState(@Nullable IErrorState state) {
        this.state = state;
        if (state != null) {
            int lineHeight = StringUtil.getLineHeight(this.maxTextWidth, new ITextProperties[]{this.getTooltip(), new TranslationTextComponent(state.getUnlocalizedHelp())});
            this.maxHeight = lineHeight + 20;
        }
    }

    @Override
    public void draw(MatrixStack transform, int y, int x) {
        if (this.state == null) {
            return;
        }
        this.drawBackground(transform, y, x);
        int xIcon = x + 5;
        int xBody = x + 14;
        int xHeader = x + 24;
        this.drawSprite(transform, this.state.getSprite(), xIcon, y += 4);
        y += 4;
        if (this.isFullyOpened()) {
            y += this.drawHeader(transform, this.getTooltip().getString(), xHeader, y);
            String helpString = Translator.translateToLocal(this.state.getUnlocalizedHelp());
            this.drawSplitText(transform, helpString, xBody, y += 4, this.maxTextWidth);
        }
    }

    @Override
    public boolean isVisible() {
        return this.state != null;
    }

    @Override
    public ITextComponent getTooltip() {
        if (this.state == null) {
            return new StringTextComponent("");
        }
        return new TranslationTextComponent(this.state.getUnlocalizedDescription());
    }
}

