/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.Translator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class HintLedger
extends Ledger {
    private final ITextComponent hintString;
    private final ITextComponent hintTooltip;

    public HintLedger(LedgerManager manager, List<String> hints) {
        super(manager, "hint");
        int position = new Random().nextInt(hints.size());
        String hint = hints.get(position);
        this.hintString = new TranslationTextComponent("for.hints." + hint + ".desc");
        this.hintTooltip = new TranslationTextComponent("for.hints." + hint + ".tag");
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int lineCount = fontRenderer.func_238425_b_((ITextProperties)this.hintString, this.maxTextWidth).size();
        fontRenderer.getClass();
        this.maxHeight = (lineCount + 1) * 9 + 20;
    }

    @Override
    public void draw(MatrixStack transform, int y, int x) {
        this.drawBackground(transform, y, x);
        this.drawSprite(transform, TextureManagerForestry.getInstance().getDefault("misc/hint"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(transform, Translator.translateToLocal("for.gui.didyouknow") + '?', x + 22, y + 8);
        this.drawSplitText(transform, this.hintString.getString(), x + 12, y + 20, this.maxTextWidth);
    }

    @Override
    public ITextComponent getTooltip() {
        return this.hintTooltip;
    }
}

