/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.config.Config;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.Translator;
import forestry.energy.EnergyManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PowerLedger
extends Ledger {
    private final EnergyManager energyManager;

    public PowerLedger(LedgerManager manager, EnergyManager energyManager) {
        super(manager, "power");
        this.energyManager = energyManager;
        this.maxHeight = 94;
    }

    @Override
    public void draw(MatrixStack transform, int y, int x) {
        this.drawBackground(transform, y, x);
        this.drawSprite(transform, TextureManagerForestry.getInstance().getDefault("misc/energy"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        int xHeader = x + 22;
        int xBody = x + 12;
        this.drawHeader(transform, Translator.translateToLocal("for.gui.energy"), xHeader, y + 8);
        this.drawSubheader(transform, Translator.translateToLocal("for.gui.stored") + ':', xBody, y + 20);
        this.drawText(transform, Config.energyDisplayMode.formatEnergyValue(this.energyManager.getEnergyStored()), xBody, y + 32);
        this.drawSubheader(transform, Translator.translateToLocal("for.gui.maxenergy") + ':', xBody, y + 44);
        this.drawText(transform, Config.energyDisplayMode.formatEnergyValue(this.energyManager.getMaxEnergyStored()), xBody, y + 56);
        this.drawSubheader(transform, Translator.translateToLocal("for.gui.maxenergyreceive") + ':', xBody, y + 68);
        this.drawText(transform, Config.energyDisplayMode.formatEnergyValue(this.energyManager.getMaxEnergyReceived()), xBody, y + 80);
    }

    @Override
    public ITextComponent getTooltip() {
        return new StringTextComponent(Config.energyDisplayMode.formatEnergyValue(this.energyManager.getEnergyStored()));
    }
}

