/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.ItemTooltipUtil;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemStackWidgetBase
extends Widget {
    public ItemStackWidgetBase(WidgetManager widgetManager, int xPos, int yPos) {
        super(widgetManager, xPos, yPos);
    }

    protected abstract ItemStack getItemStack();

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.func_190926_b()) {
            GuiUtil.drawItemStack(this.manager.gui, itemStack, this.xPos + startX, this.yPos + startY);
            RenderHelper.func_74518_a();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ItemStack itemStack = this.getItemStack();
        ToolTip tip = new ToolTip();
        if (!itemStack.func_190926_b()) {
            tip.addAll(ItemTooltipUtil.getInformation(itemStack));
        }
        return tip;
    }
}

