/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiEscritoire;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SoundUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ProbeButton
extends Widget {
    private final GuiEscritoire guiEscritoire;
    private boolean pressed;

    public ProbeButton(GuiEscritoire guiEscritoire, WidgetManager manager, int xPos, int yPos) {
        super(manager, xPos, yPos);
        this.guiEscritoire = guiEscritoire;
        this.width = 22;
        this.height = 25;
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.manager.gui.textureFile);
        this.manager.gui.func_238474_b_(transform, startX + this.xPos, startY + this.yPos, 228, this.pressed ? 47 : 22, this.width, this.height);
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ToolTip tooltip = new ToolTip();
        tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.escritoire.probe"));
        return tooltip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        this.pressed = true;
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(-1, 0));
        SoundUtil.playButtonClick();
    }

    @Override
    public boolean handleMouseRelease(double mouseX, double mouseY, int eventType) {
        if (this.pressed) {
            this.pressed = false;
        }
        return false;
    }

    @Override
    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
        if (this.manager.getAtPosition(mouseX - this.guiEscritoire.getGuiLeft(), mouseY - this.guiEscritoire.getGuiTop()) != this) {
            this.pressed = false;
        }
    }
}

