/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gui.IContainerSocketed;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.ItemTooltipUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SocketWidget
extends Widget {
    private final ISocketable tile;
    private final int slot;
    private final ToolTip toolTip = new ToolTip(250){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void refresh() {
            SocketWidget.this.toolTip.clear();
            ItemStack stack = SocketWidget.this.tile.getSocket(SocketWidget.this.slot);
            if (!stack.func_190926_b()) {
                SocketWidget.this.toolTip.addAll(ItemTooltipUtil.getInformation(stack));
                SocketWidget.this.toolTip.add((ITextComponent)new TranslationTextComponent("for.gui.socket.remove").func_240699_a_(TextFormatting.ITALIC));
            } else {
                SocketWidget.this.toolTip.add((ITextComponent)new TranslationTextComponent("for.gui.emptysocket"));
            }
        }
    };

    public SocketWidget(WidgetManager manager, int xPos, int yPos, ISocketable tile, int slot) {
        super(manager, xPos, yPos);
        this.tile = tile;
        this.slot = slot;
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        ItemStack socketStack = this.tile.getSocket(this.slot);
        if (!socketStack.func_190926_b()) {
            Minecraft.func_71410_x().func_175599_af().func_175042_a(socketStack, startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack.func_190926_b()) {
            return;
        }
        Item held = itemstack.func_77973_b();
        Container container = this.manager.gui.func_212873_a_();
        if (!(container instanceof IContainerSocketed)) {
            return;
        }
        IContainerSocketed containerSocketed = (IContainerSocketed)container;
        if (held instanceof ItemCircuitBoard) {
            containerSocketed.handleChipsetClick(this.slot);
        } else if (held instanceof ISolderingIron) {
            containerSocketed.handleSolderingIronClick(this.slot);
        }
    }
}

