/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.gui.Drawable;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;

public class WidgetSlider
extends Widget {
    private final Drawable texture;
    private int xOffset;
    private int yOffset;

    public WidgetSlider(WidgetManager manager, int xPos, int yPos, Drawable texture) {
        super(manager, xPos, yPos);
        this.texture = texture;
        this.width = texture.uWidth;
        this.height = texture.vHeight;
    }

    public void setOffset(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.texture.draw(transform, startY + this.yPos + this.yOffset, startX + this.xPos + this.xOffset);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        int xPos = this.xPos + this.xOffset;
        int yPos = this.yPos + this.yOffset;
        return mouseX >= (double)xPos && mouseX <= (double)(xPos + this.width) && mouseY >= (double)yPos && mouseY <= (double)(yPos + this.height);
    }
}

