/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IToolPipette;
import forestry.core.ItemGroupForestry;
import forestry.core.fluids.PipetteContents;
import forestry.core.items.ItemForestry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemPipette
extends ItemForestry
implements IToolPipette {
    @OnlyIn(value=Dist.CLIENT)
    public ModelResourceLocation[] models;

    public ItemPipette() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroupForestry.tabForestry));
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = PipetteContents.create(itemstack);
        return contained == null || !contained.isFull();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null) {
            return;
        }
        PipetteContents contained = PipetteContents.create(itemstack);
        if (contained != null) {
            contained.addTooltip(list);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack(stack, 1000);
    }
}

