/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.gui.ContainerItemInventory;
import forestry.core.items.ItemForestry;
import forestry.core.network.PacketBufferForestry;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class ItemWithGui
extends ItemForestry {
    public ItemWithGui(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            ServerPlayerEntity sPlayer = (ServerPlayerEntity)playerIn;
            this.openGui(sPlayer, stack);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    protected void openGui(ServerPlayerEntity player, ItemStack stack) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ContainerProvider(stack), buffer -> this.writeContainerData(player, stack, new PacketBufferForestry((ByteBuf)buffer)));
    }

    protected void writeContainerData(ServerPlayerEntity player, ItemStack stack, PacketBufferForestry buffer) {
        buffer.writeBoolean(player.func_184600_cs() == Hand.MAIN_HAND);
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, PlayerEntity player) {
        if (!itemstack.func_190926_b() && player instanceof ServerPlayerEntity && player.field_71070_bA instanceof ContainerItemInventory) {
            player.func_71053_j();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    @Nullable
    public abstract Container getContainer(int var1, PlayerEntity var2, ItemStack var3);

    public static class ContainerProvider
    implements INamedContainerProvider {
        private final ItemStack heldItem;

        public ContainerProvider(ItemStack heldItem) {
            this.heldItem = heldItem;
        }

        public ITextComponent func_145748_c_() {
            return this.heldItem.func_200301_q();
        }

        @Nullable
        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            Item item = this.heldItem.func_77973_b();
            if (!(item instanceof ItemWithGui)) {
                return null;
            }
            ItemWithGui itemWithGui = (ItemWithGui)item;
            return itemWithGui.getContainer(windowId, playerEntity, this.heldItem);
        }
    }
}

