/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import forestry.core.blocks.IColoredBlock;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.utils.ResourceUtil;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureGroup;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientManager {
    private static final ClientManager instance = new ClientManager();
    private final List<BlockModelEntry> customBlockModels = new ArrayList<BlockModelEntry>();
    private final List<ModelEntry> customModels = new ArrayList<ModelEntry>();
    private final Set<IColoredBlock> blockColorList = new HashSet<IColoredBlock>();
    private final Set<IColoredItem> itemColorList = new HashSet<IColoredItem>();
    @Nullable
    private IModelTransform defaultBlockState;
    @Nullable
    private IModelTransform defaultItemState;

    public static ClientManager getInstance() {
        return instance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockClient(Block block) {
        if (block instanceof IColoredBlock) {
            this.blockColorList.add((IColoredBlock)block);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemClient(Item item) {
        if (item instanceof IColoredItem) {
            this.itemColorList.add((IColoredItem)item);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemAndBlockColors() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockColors blockColors = minecraft.func_184125_al();
        for (IColoredBlock blockColor : this.blockColorList) {
            if (!(blockColor instanceof Block)) continue;
            blockColors.func_186722_a((IBlockColor)ColoredBlockBlockColor.INSTANCE, new Block[]{(Block)blockColor});
        }
        ItemColors itemColors = minecraft.getItemColors();
        for (IColoredItem itemColor : this.itemColorList) {
            if (!(itemColor instanceof Item)) continue;
            itemColors.func_199877_a((IItemColor)ColoredItemItemColor.INSTANCE, new IItemProvider[]{(Item)itemColor});
        }
    }

    public IModelTransform getDefaultBlockState() {
        if (this.defaultBlockState == null) {
            this.defaultBlockState = ResourceUtil.loadTransform(new ResourceLocation("block/block"));
        }
        return this.defaultBlockState;
    }

    public IModelTransform getDefaultItemState() {
        if (this.defaultItemState == null) {
            this.defaultItemState = ResourceUtil.loadTransform(new ResourceLocation("item/generated"));
        }
        return this.defaultItemState;
    }

    public void registerModel(IBakedModel model, Object feature) {
        if (feature instanceof FeatureGroup) {
            FeatureGroup group = (FeatureGroup)feature;
            group.getFeatures().forEach(f -> this.registerModel(model, f));
        } else if (feature instanceof FeatureTable) {
            FeatureTable group = (FeatureTable)feature;
            group.getFeatures().forEach(f -> this.registerModel(model, f));
        } else if (feature instanceof FeatureBlock) {
            FeatureBlock block = (FeatureBlock)feature;
            this.registerModel(model, (Block)block.block(), (BlockItem)block.getItem());
        } else if (feature instanceof FeatureItem) {
            FeatureItem item = (FeatureItem)feature;
            this.registerModel(model, (Item)item.item());
        }
    }

    public void registerModel(IBakedModel model, Block block, @Nullable BlockItem item) {
        this.registerModel(model, block, item, (Collection<BlockState>)block.func_176194_O().func_177619_a());
    }

    public void registerModel(IBakedModel model, Block block, @Nullable BlockItem item, Collection<BlockState> states) {
        this.customBlockModels.add(new BlockModelEntry(model, block, item, states));
    }

    public void registerModel(IBakedModel model, Item item) {
        this.customModels.add(new ModelEntry(new ModelResourceLocation(item.getRegistryName(), "inventory"), model));
    }

    public void onBakeModels(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        for (BlockModelEntry blockModelEntry : this.customBlockModels) {
            ResourceLocation registryName;
            for (BlockState state : blockModelEntry.states) {
                registry.put(BlockModelShapes.func_209554_c((BlockState)state), blockModelEntry.model);
            }
            if (blockModelEntry.item == null || (registryName = blockModelEntry.item.getRegistryName()) == null) continue;
            registry.put(new ModelResourceLocation(registryName, "inventory"), blockModelEntry.model);
        }
        for (ModelEntry modelEntry : this.customModels) {
            registry.put(modelEntry.modelLocation, modelEntry.model);
        }
    }

    private static class ModelEntry {
        private final ModelResourceLocation modelLocation;
        private final IBakedModel model;

        private ModelEntry(ModelResourceLocation modelLocation, IBakedModel model) {
            this.modelLocation = modelLocation;
            this.model = model;
        }
    }

    private static class BlockModelEntry {
        private final IBakedModel model;
        private final Block block;
        private final Collection<BlockState> states;
        @Nullable
        private final BlockItem item;

        private BlockModelEntry(IBakedModel model, Block block, @Nullable BlockItem item, Collection<BlockState> states) {
            this.model = model;
            this.block = block;
            this.item = item;
            this.states = states;
        }
    }

    private static class ColoredBlockBlockColor
    implements IBlockColor {
        public static final ColoredBlockBlockColor INSTANCE = new ColoredBlockBlockColor();

        private ColoredBlockBlockColor() {
        }

        public int getColor(BlockState state, @Nullable IBlockDisplayReader worldIn, @Nullable BlockPos pos, int tintIndex) {
            Block block = state.func_177230_c();
            if (block instanceof IColoredBlock && worldIn != null && pos != null) {
                return ((IColoredBlock)block).colorMultiplier(state, (IBlockReader)worldIn, pos, tintIndex);
            }
            return 0xFFFFFF;
        }
    }

    private static class ColoredItemItemColor
    implements IItemColor {
        public static final ColoredItemItemColor INSTANCE = new ColoredItemItemColor();

        private ColoredItemItemColor() {
        }

        public int getColor(ItemStack stack, int tintIndex) {
            Item item = stack.func_77973_b();
            if (item instanceof IColoredItem) {
                return ((IColoredItem)item).getColorFromItemStack(stack, tintIndex);
            }
            return 0xFFFFFF;
        }
    }
}

