/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import forestry.core.models.ModelBlockDefault;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModelBlockCached<B extends Block, K>
extends ModelBlockDefault<B, K> {
    private static final Set<ModelBlockCached> CACHE_PROVIDERS = new HashSet<ModelBlockCached>();
    private final Cache<K, IBakedModel> inventoryCache;
    private final Cache<K, IBakedModel> worldCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public static void clear() {
        for (ModelBlockCached modelBlockCached : CACHE_PROVIDERS) {
            modelBlockCached.worldCache.invalidateAll();
            modelBlockCached.inventoryCache.invalidateAll();
        }
    }

    protected ModelBlockCached(Class<B> blockClass) {
        super(blockClass);
        this.inventoryCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        CACHE_PROVIDERS.add(this);
    }

    @Override
    protected IBakedModel getModel(BlockState state, IModelData extraData) {
        Object key = this.getWorldKey(state, extraData);
        IBakedModel model = (IBakedModel)this.worldCache.getIfPresent(key);
        if (model == null) {
            model = super.getModel(state, extraData);
            this.worldCache.put(key, (Object)model);
        }
        return model;
    }

    @Override
    protected IBakedModel getModel(ItemStack stack, World world) {
        Object key = this.getInventoryKey(stack);
        IBakedModel model = (IBakedModel)this.inventoryCache.getIfPresent(key);
        if (model == null) {
            model = this.bakeModel(stack, world, key);
            this.inventoryCache.put(key, (Object)model);
        }
        return model;
    }
}

