/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Preconditions;
import forestry.core.models.baker.ModelBaker;
import forestry.core.models.baker.ModelBakerModel;
import forestry.core.utils.ResourceUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModelBlockDefault<B extends Block, K>
implements IBakedModel {
    @Nullable
    private ItemOverrideList overrideList;
    protected final Class<B> blockClass;
    @Nullable
    protected ModelBakerModel blockModel;
    @Nullable
    protected ModelBakerModel itemModel;

    protected ModelBlockDefault(Class<B> blockClass) {
        this.blockClass = blockClass;
    }

    protected IBakedModel bakeModel(BlockState state, K key, B block, IModelData extraData) {
        ModelBaker baker = new ModelBaker();
        this.bakeBlock(block, extraData, key, baker, false);
        this.blockModel = baker.bake(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    protected IBakedModel getModel(BlockState state, IModelData extraData) {
        Preconditions.checkArgument((boolean)this.blockClass.isInstance(state.func_177230_c()));
        K worldKey = this.getWorldKey(state, extraData);
        Block block = (Block)this.blockClass.cast(state.func_177230_c());
        return this.bakeModel(state, worldKey, block, extraData);
    }

    protected IBakedModel bakeModel(ItemStack stack, World world, K key) {
        ModelBaker baker = new ModelBaker();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Preconditions.checkArgument((boolean)this.blockClass.isInstance(block));
        Block bBlock = (Block)this.blockClass.cast(block);
        this.bakeBlock(bBlock, (IModelData)EmptyModelData.INSTANCE, key, baker, true);
        this.itemModel = baker.bake(true);
        return this.itemModel;
    }

    protected IBakedModel getModel(ItemStack stack, World world) {
        return this.bakeModel(stack, world, this.getInventoryKey(stack));
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Preconditions.checkNotNull((Object)state);
        IBakedModel model = this.getModel(state, extraData);
        return model.getQuads(state, side, rand, extraData);
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    protected void onCreateModel(ModelBakerModel model) {
        model.setAmbientOcclusion(true);
    }

    public boolean func_177555_b() {
        return (this.itemModel != null || this.blockModel != null) && (this.blockModel != null ? this.blockModel.func_177555_b() : this.itemModel.func_177555_b());
    }

    public boolean func_177556_c() {
        return this.itemModel != null && this.itemModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return (this.itemModel != null || this.blockModel != null) && (this.blockModel != null ? this.blockModel.func_188618_c() : this.itemModel.func_188618_c());
    }

    public boolean func_230044_c_() {
        return this.itemModel != null && this.itemModel.func_230044_c_();
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.blockModel != null) {
            return this.blockModel.func_177554_e();
        }
        return ResourceUtil.getMissingTexture();
    }

    public ItemCameraTransforms func_177552_f() {
        if (this.itemModel == null) {
            return ItemCameraTransforms.field_178357_a;
        }
        return this.itemModel.func_177552_f();
    }

    protected ItemOverrideList createOverrides() {
        return new DefaultItemOverrideList();
    }

    public ItemOverrideList func_188617_f() {
        if (this.overrideList == null) {
            this.overrideList = this.createOverrides();
        }
        return this.overrideList;
    }

    protected abstract K getInventoryKey(ItemStack var1);

    protected abstract K getWorldKey(BlockState var1, IModelData var2);

    protected abstract void bakeBlock(B var1, IModelData var2, K var3, ModelBaker var4, boolean var5);

    private class DefaultItemOverrideList
    extends ItemOverrideList {
        @Nullable
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            if (world == null) {
                world = Minecraft.func_71410_x().field_71441_e;
            }
            return ModelBlockDefault.this.getModel(stack, (World)world);
        }
    }
}

