/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models.baker;

import forestry.core.models.ClientManager;
import forestry.core.models.baker.ModelBakerFace;
import forestry.core.models.baker.ModelBakerModel;
import forestry.core.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ModelBaker {
    private static final ResourceLocation FACE_LOCATION = new ResourceLocation("forestry", "baker_face");
    private static final float[] UVS = new float[]{0.0f, 0.0f, 16.0f, 16.0f, 0.0f, 0.0f, 16.0f, 16.0f};
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private static final Vector3f POS_FROM = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f POS_TO = new Vector3f(16.0f, 16.0f, 16.0f);
    private final List<ModelBakerFace> faces = new ArrayList<ModelBakerFace>();
    private final ModelBakerModel currentModel = new ModelBakerModel(ClientManager.getInstance().getDefaultBlockState());
    private int colorIndex = -1;

    public ModelBaker addBlockModel(TextureAtlasSprite[] textures, int colorIndex) {
        this.colorIndex = colorIndex;
        for (Direction facing : Direction.field_199792_n) {
            this.addFace(facing, textures[facing.ordinal()]);
        }
        return this;
    }

    public ModelBaker addBlockModel(TextureAtlasSprite texture, int colorIndex) {
        return this.addBlockModel(new TextureAtlasSprite[]{texture, texture, texture, texture, texture, texture}, colorIndex);
    }

    public ModelBaker addFace(Direction facing, TextureAtlasSprite sprite) {
        if (sprite != ResourceUtil.getMissingTexture()) {
            this.faces.add(new ModelBakerFace(facing, this.colorIndex, sprite));
        }
        return this;
    }

    public ModelBakerModel bake(boolean flip) {
        ModelRotation modelRotation = ModelRotation.X0_Y0;
        if (flip) {
            modelRotation = ModelRotation.X0_Y180;
        }
        for (ModelBakerFace face : this.faces) {
            Direction facing = face.face;
            BlockFaceUV uvFace = new BlockFaceUV(UVS, 0);
            BlockPartFace partFace = new BlockPartFace(facing, face.colorIndex, "", uvFace);
            BakedQuad quad = FACE_BAKERY.func_228824_a_(POS_FROM, POS_TO, partFace, face.spite, facing, (IModelTransform)modelRotation, null, true, FACE_LOCATION);
            this.currentModel.addQuad(facing, quad);
        }
        return this.currentModel;
    }

    public void setParticleSprite(TextureAtlasSprite particleSprite) {
        this.currentModel.setParticleSprite(particleSprite);
    }
}

