/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models.baker;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakerModel
implements IBakedModel {
    private boolean isGui3d;
    private boolean isAmbientOcclusion;
    private TextureAtlasSprite particleSprite;
    @Nullable
    private IModelTransform modelState;
    private ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms = ImmutableMap.of();
    private final Map<Direction, List<BakedQuad>> faceQuads;
    private final List<BakedQuad> generalQuads;
    private final List<Pair<BlockState, IBakedModel>> models;
    private final List<Pair<BlockState, IBakedModel>> modelsPost;
    private float[] rotation = ModelBakerModel.getDefaultRotation();
    private float[] translation = ModelBakerModel.getDefaultTranslation();
    private float[] scale = ModelBakerModel.getDefaultScale();

    ModelBakerModel(IModelTransform modelState) {
        this.models = new ArrayList<Pair<BlockState, IBakedModel>>();
        this.modelsPost = new ArrayList<Pair<BlockState, IBakedModel>>();
        this.faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        this.generalQuads = new ArrayList<BakedQuad>();
        this.particleSprite = ResourceUtil.getMissingTexture();
        this.isGui3d = true;
        this.isAmbientOcclusion = false;
        this.setModelState(modelState);
        for (Direction face : Direction.field_199792_n) {
            this.faceQuads.put(face, new ArrayList());
        }
    }

    private ModelBakerModel(ModelBakerModel old) {
        this.models = new ArrayList<Pair<BlockState, IBakedModel>>(old.models);
        this.modelsPost = new ArrayList<Pair<BlockState, IBakedModel>>(old.modelsPost);
        this.faceQuads = new EnumMap<Direction, List<BakedQuad>>(old.faceQuads);
        this.generalQuads = new ArrayList<BakedQuad>(old.generalQuads);
        this.isGui3d = old.isGui3d;
        this.isAmbientOcclusion = old.isAmbientOcclusion;
        this.rotation = Arrays.copyOf(old.rotation, 3);
        this.translation = Arrays.copyOf(old.translation, 3);
        this.scale = Arrays.copyOf(old.scale, 3);
        this.particleSprite = old.particleSprite;
        this.setModelState(old.modelState);
    }

    public boolean func_177556_c() {
        return this.isGui3d;
    }

    public boolean func_230044_c_() {
        return true;
    }

    public void setAmbientOcclusion(boolean ambientOcclusion) {
        this.isAmbientOcclusion = ambientOcclusion;
    }

    public boolean func_177555_b() {
        return this.isAmbientOcclusion;
    }

    public void setParticleSprite(TextureAtlasSprite particleSprite) {
        this.particleSprite = particleSprite;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleSprite;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private static float[] getDefaultRotation() {
        return new float[]{-80.0f, -45.0f, 170.0f};
    }

    private static float[] getDefaultTranslation() {
        return new float[]{0.0f, 1.5f, -2.75f};
    }

    private static float[] getDefaultScale() {
        return new float[]{0.375f, 0.375f, 0.375f};
    }

    public void setRotation(float[] rotation) {
        this.rotation = rotation;
    }

    public void setTranslation(float[] translation) {
        this.translation = translation;
    }

    public void setScale(float[] scale) {
        this.scale = scale;
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public float[] getTranslation() {
        return this.translation;
    }

    public float[] getScale() {
        return this.scale;
    }

    public void setModelState(IModelTransform modelState) {
        this.modelState = modelState;
        this.transforms = PerspectiveMapWrapper.getTransforms((IModelTransform)modelState);
    }

    public void addQuad(@Nullable Direction facing, BakedQuad quad) {
        if (facing != null) {
            this.faceQuads.get(facing).add(quad);
        } else {
            this.generalQuads.add(quad);
        }
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        List modelQuads;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Pair<BlockState, IBakedModel> model : this.models) {
            modelQuads = ((IBakedModel)model.getRight()).func_200117_a((BlockState)model.getLeft(), side, rand);
            if (modelQuads.isEmpty()) continue;
            quads.addAll(modelQuads);
        }
        if (side != null) {
            quads.addAll((Collection)this.faceQuads.get(side));
        }
        quads.addAll(this.generalQuads);
        for (Pair<BlockState, IBakedModel> model : this.modelsPost) {
            modelQuads = ((IBakedModel)model.getRight()).func_200117_a((BlockState)model.getLeft(), side, rand);
            if (modelQuads.isEmpty()) continue;
            quads.addAll(modelQuads);
        }
        return quads;
    }

    public ModelBakerModel copy() {
        return new ModelBakerModel(this);
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType, (MatrixStack)mat);
    }

    public boolean doesHandlePerspectives() {
        return true;
    }
}

