/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketHandlerServer;
import forestry.core.network.PacketIdClient;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PacketHandlerClient {
    private static final Logger LOGGER = LogManager.getLogger();

    public void onPacket(NetworkEvent.ServerCustomPayloadEvent event) {
        PacketBufferForestry data = new PacketBufferForestry((ByteBuf)event.getPayload());
        byte idOrdinal = data.readByte();
        PacketIdClient id = PacketIdClient.VALUES[idOrdinal];
        IForestryPacketHandlerClient packetHandler = id.getPacketHandler();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            LOGGER.warn("the player was null, event: {}", (Object)event);
            return;
        }
        try {
            packetHandler.onPacketData(data, (PlayerEntity)player);
        }
        catch (IOException e) {
            LOGGER.error("exception handling packet", (Throwable)e);
            return;
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    public static void sendPacket(IForestryPacketServer packet) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayNetHandler netHandler = minecraft.func_147114_u();
        if (netHandler != null) {
            Pair<PacketBuffer, Integer> packetData = packet.getPacketData();
            ICustomPacket payload = NetworkDirection.PLAY_TO_SERVER.buildPacket(packetData, PacketHandlerServer.CHANNEL_ID);
            netHandler.func_147297_a(payload.getThis());
        }
    }
}

