/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ForestryEvent;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import genetics.api.GeneticsAPI;
import genetics.api.root.IRootDefinition;
import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PacketGenomeTrackerSync
extends ForestryPacket
implements IForestryPacketClient {
    private final CompoundNBT nbt;

    public PacketGenomeTrackerSync(CompoundNBT CompoundNBT2) {
        this.nbt = CompoundNBT2;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.GENOME_TRACKER_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_150786_a(this.nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            CompoundNBT nbt = data.func_150793_b();
            if (nbt != null) {
                String type = nbt.func_74779_i("TYPE");
                IRootDefinition<IForestrySpeciesRoot> definition = GeneticsAPI.apiInstance.getRoot(type);
                definition.ifPresent(root -> {
                    IBreedingTracker tracker = root.getBreedingTracker((IWorld)player.func_130014_f_(), player.func_146103_bH());
                    tracker.decodeFromNBT(nbt);
                    MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
                });
            }
        }
    }
}

