/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.owner;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;

public class GameProfileDataSerializer
implements IDataSerializer<Optional<GameProfile>> {
    public static final GameProfileDataSerializer INSTANCE = new GameProfileDataSerializer();

    public static void register() {
        DataSerializers.func_187189_a((IDataSerializer)INSTANCE);
    }

    private GameProfileDataSerializer() {
    }

    public void write(PacketBuffer buf, Optional<GameProfile> value) {
        if (!value.isPresent()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            GameProfile gameProfile = value.get();
            buf.func_179252_a(gameProfile.getId());
            buf.func_180714_a(gameProfile.getName());
        }
    }

    public Optional<GameProfile> read(PacketBuffer buf) {
        if (buf.readBoolean()) {
            UUID uuid = buf.func_179253_g();
            String name = buf.func_150789_c(1024);
            GameProfile gameProfile = new GameProfile(uuid, name);
            return Optional.of(gameProfile);
        }
        return Optional.empty();
    }

    public DataParameter<Optional<GameProfile>> func_187161_a(int id) {
        return new DataParameter(id, (IDataSerializer)this);
    }

    public Optional<GameProfile> copy(Optional<GameProfile> value) {
        return value;
    }
}

