/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class FallbackIngredient
extends Ingredient {
    private final Ingredient primary;
    private final Ingredient fallback;

    public static Ingredient fromItems(IItemProvider primary, IItemProvider fallback) {
        return FallbackIngredient.fromIngredients(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{primary}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{fallback}));
    }

    public static Ingredient fromStacks(ItemStack primary, ItemStack fallback) {
        return FallbackIngredient.fromIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{primary}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{fallback}));
    }

    public static Ingredient fromTag(ITag<Item> primary, ItemStack fallback) {
        return FallbackIngredient.fromIngredients(Ingredient.func_199805_a(primary), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{fallback}));
    }

    public static Ingredient fromTag(ITag<Item> primary, ITag<Item> fallback) {
        return FallbackIngredient.fromIngredients(Ingredient.func_199805_a(primary), Ingredient.func_199805_a(fallback));
    }

    public static Ingredient fromIngredients(Ingredient primary, Ingredient fallback) {
        return new FallbackIngredient(primary, fallback);
    }

    private FallbackIngredient(Ingredient primary, Ingredient fallback) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.primary = primary;
        this.fallback = fallback;
    }

    public JsonElement func_200304_c() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("primary", this.primary.func_200304_c());
        jsonobject.add("fallback", this.fallback.func_200304_c());
        return jsonobject;
    }

    public static class Serializer
    implements IIngredientSerializer<Ingredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public Ingredient parse(PacketBuffer buffer) {
            return Ingredient.func_199566_b((PacketBuffer)buffer);
        }

        public void write(PacketBuffer buffer, Ingredient ingredient) {
            ingredient.func_199564_a(buffer);
        }

        @Nonnull
        public Ingredient parse(JsonObject json) {
            Ingredient ret;
            JsonObject obj;
            try {
                JsonArray arr = JSONUtils.func_151214_t((JsonObject)json, (String)"primary");
                ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>();
                for (JsonElement element : arr) {
                    if (!(element instanceof JsonObject)) {
                        throw new JsonSyntaxException("Didn't supply json object for ingredient!");
                    }
                    obj = (JsonObject)element;
                    ingredientList.add(CraftingHelper.getIngredient((JsonElement)obj));
                }
                ret = Ingredient.merge(ingredientList);
            }
            catch (JsonSyntaxException e) {
                ret = Ingredient.field_193370_a;
            }
            if (ret.func_193365_a().length == 0) {
                JsonArray fallbackArr = JSONUtils.func_151214_t((JsonObject)json, (String)"fallback");
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
                for (JsonElement element : fallbackArr) {
                    if (!(element instanceof JsonObject)) {
                        throw new JsonSyntaxException("Didn't supply json object for ingredient!");
                    }
                    obj = (JsonObject)element;
                    ingredients.add(CraftingHelper.getIngredient((JsonElement)obj));
                }
                ret = Ingredient.merge(ingredients);
            }
            return ret;
        }
    }
}

