/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.IHygroregulatorManager;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.core.recipes.HygroregulatorRecipe;
import forestry.factory.recipes.AbstractCraftingProvider;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class HygroregulatorManager
extends AbstractCraftingProvider<IHygroregulatorRecipe>
implements IHygroregulatorManager {
    public HygroregulatorManager() {
        super(IHygroregulatorRecipe.TYPE);
    }

    @Override
    public void addRecipe(FluidStack resource, int transferTime, float tempChange, float humidChange) {
        this.addRecipe(new HygroregulatorRecipe(IForestryRecipe.anonymous(), resource, transferTime, humidChange, tempChange));
    }

    @Override
    @Nullable
    public IHygroregulatorRecipe findMatchingRecipe(@Nullable RecipeManager recipeManager, FluidStack liquid) {
        if (liquid.getAmount() <= 0) {
            return null;
        }
        for (IHygroregulatorRecipe recipe : this.getRecipes(recipeManager)) {
            FluidStack resource = recipe.getResource();
            if (!resource.isFluidEqual(liquid)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public Set<ResourceLocation> getRecipeFluids(@Nullable RecipeManager recipeManager) {
        return this.getRecipes(recipeManager).stream().map(recipe -> recipe.getResource().getFluid().getRegistryName()).collect(Collectors.toSet());
    }
}

