/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.core.ForestryAPI;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ModuleEnabledCondition
implements ICondition {
    private final String container;
    private final String module;

    public ModuleEnabledCondition(String container, String module) {
        this.container = container;
        this.module = module;
    }

    public ResourceLocation getID() {
        return new ResourceLocation("forestry", "module");
    }

    public boolean test() {
        return ForestryAPI.enabledModules.contains(new ResourceLocation(this.container, this.module));
    }

    public String toString() {
        return "module_enabled(container=\"" + this.container + "\",module=\"" + this.module + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ModuleEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ModuleEnabledCondition value) {
            json.addProperty("module", value.module);
            json.addProperty("container", value.container);
        }

        public ModuleEnabledCondition read(JsonObject json) {
            String module = json.get("module").getAsString();
            JsonElement conElement = json.get("container");
            String container = conElement == null ? "forestry" : conElement.getAsString();
            return new ModuleEnabledCondition(container, module);
        }

        public ResourceLocation getID() {
            return new ResourceLocation("forestry", "module");
        }
    }
}

