/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.registration;

import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;

public class VillagerTrade {

    public static class PriceInterval {
        private final int min;
        private final int max;

        public PriceInterval(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getPrice(Random rand) {
            return this.min >= this.max ? this.min : this.min + rand.nextInt(this.max - this.min + 1);
        }
    }

    public static class GiveItemForTwoItems
    implements VillagerTrades.ITrade {
        final int maxUses;
        final int xp;
        final Item buyingItem;
        final PriceInterval buyAmounts;
        final Item buyingItem2;
        final PriceInterval buyAmounts2;
        final Item sellingItem;
        final PriceInterval sellingAmounts;

        public GiveItemForTwoItems(Item buyingItem, PriceInterval buyAmounts, Item buyingItem2, PriceInterval buyAmounts2, Item sellingItem, PriceInterval sellingAmounts, int maxUses, int xp) {
            this.buyingItem = buyingItem;
            this.buyAmounts = buyAmounts;
            this.buyingItem2 = buyingItem2;
            this.buyAmounts2 = buyAmounts2;
            this.sellingItem = sellingItem;
            this.sellingAmounts = sellingAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)this.buyingItem, this.buyAmounts.getPrice(rand)), new ItemStack((IItemProvider)this.buyingItem2, this.buyAmounts2.getPrice(rand)), new ItemStack((IItemProvider)this.sellingItem, this.sellingAmounts.getPrice(rand)), this.maxUses, this.xp, 0.05f);
        }
    }

    public static class GiveItemForLogAndEmerald
    implements VillagerTrades.ITrade {
        final int maxUses;
        final int xp;
        final PriceInterval buyAmounts;
        final PriceInterval emeraldAmounts;
        final Item sellingItem;
        final PriceInterval sellingAmounts;

        public GiveItemForLogAndEmerald(PriceInterval buyAmounts, PriceInterval emeraldAmounts, Item sellingItem, PriceInterval sellingAmounts, int maxUses, int xp) {
            this.buyAmounts = buyAmounts;
            this.emeraldAmounts = emeraldAmounts;
            this.sellingItem = sellingItem;
            this.sellingAmounts = sellingAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            HashSet<Item> logsBlock = new HashSet<Item>();
            logsBlock.add(Items.field_221558_K);
            logsBlock.add(Items.field_221556_I);
            logsBlock.add(Items.field_221559_L);
            logsBlock.add(Items.field_221557_J);
            logsBlock.add(Items.field_221554_G);
            logsBlock.add(Items.field_221555_H);
            return new MerchantOffer(new ItemStack((IItemProvider)logsBlock.stream().skip((int)((double)logsBlock.size() * Math.random())).findFirst().get(), this.buyAmounts.getPrice(rand)), new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldAmounts.getPrice(rand)), new ItemStack((IItemProvider)this.sellingItem, this.sellingAmounts.getPrice(rand)), this.maxUses, this.xp, 0.05f);
        }
    }

    public static class GiveItemForItemAndEmerald
    implements VillagerTrades.ITrade {
        final int maxUses;
        final int xp;
        final Item buyingItem;
        final PriceInterval buyAmounts;
        final PriceInterval emeralsAmounts;
        final Item sellingItem;
        final PriceInterval sellingAmounts;

        public GiveItemForItemAndEmerald(Item buyingItem, PriceInterval buyAmounts, PriceInterval emeralsAmounts, Item sellingItem, PriceInterval sellingAmounts, int maxUses, int xp) {
            this.buyingItem = buyingItem;
            this.buyAmounts = buyAmounts;
            this.emeralsAmounts = emeralsAmounts;
            this.sellingItem = sellingItem;
            this.sellingAmounts = sellingAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)this.buyingItem, this.buyAmounts.getPrice(rand)), new ItemStack((IItemProvider)Items.field_151166_bC, this.emeralsAmounts.getPrice(rand)), new ItemStack((IItemProvider)this.sellingItem, this.sellingAmounts.getPrice(rand)), this.maxUses, this.xp, 0.05f);
        }
    }

    public static class GiveEmeraldForItem
    implements VillagerTrades.ITrade {
        final int maxUses;
        final int xp;
        final Item buyingItem;
        final PriceInterval buyingAmounts;
        final PriceInterval emeraldAmounts;

        public GiveEmeraldForItem(Item buyingItem, PriceInterval buyingAmounts, PriceInterval emeraldAmounts, int maxUses, int xp) {
            this.buyingItem = buyingItem;
            this.buyingAmounts = buyingAmounts;
            this.emeraldAmounts = emeraldAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)this.buyingItem, this.buyingAmounts.getPrice(rand)), new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldAmounts.getPrice(rand)), this.maxUses, this.xp, 0.05f);
        }
    }

    public static class GiveItemForEmeralds
    implements VillagerTrades.ITrade {
        final int maxUses;
        final int xp;
        final Item sellingItem;
        final PriceInterval sellingAmounts;
        final PriceInterval emeraldAmounts;

        public GiveItemForEmeralds(@Nonnull Item sellingItem, @Nonnull PriceInterval sellingAmounts, @Nonnull PriceInterval emeraldAmounts, int maxUses, int xp) {
            this.sellingItem = sellingItem;
            this.sellingAmounts = sellingAmounts;
            this.emeraldAmounts = emeraldAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldAmounts.getPrice(rand)), new ItemStack((IItemProvider)this.sellingItem, this.sellingAmounts.getPrice(rand)), this.maxUses, this.xp, 0.05f);
        }
    }
}

