/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Predicate;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

@OnlyIn(value=Dist.CLIENT)
public class ColourProperties
implements ISelectiveResourceReloadListener {
    public static final ColourProperties INSTANCE = new ColourProperties();
    private final Properties defaultMappings = new Properties();
    private final Properties mappings = new Properties();

    private ColourProperties() {
    }

    public synchronized int get(String key) {
        return Integer.parseInt(this.mappings.getProperty(key, this.defaultMappings.getProperty(key, "d67fff")), 16);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> pred) {
        try {
            InputStream defaultFontStream = ColourProperties.class.getResourceAsStream("/config/forestry/colour.properties");
            this.mappings.load(defaultFontStream);
            this.defaultMappings.load(defaultFontStream);
            defaultFontStream.close();
        }
        catch (IOException e) {
            Log.error("Failed to load colors.properties.", e);
        }
    }
}

