/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.render.ParticleHelper;
import forestry.core.utils.ResourceUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MachineParticleCallback<P extends Enum<P> & IStringSerializable>
extends ParticleHelper.DefaultCallback<BlockBase<?>> {
    private final P blockType;

    public MachineParticleCallback(BlockBase<?> block, P blockType) {
        super(block);
        this.blockType = blockType;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void setTexture(DiggingParticle fx, World world, BlockPos pos, BlockState state) {
        IMachineProperties<?> properties = ((IBlockType)this.blockType).getMachineProperties();
        if (properties instanceof IMachinePropertiesTesr) {
            IMachinePropertiesTesr propertiesTesr = (IMachinePropertiesTesr)properties;
            fx.field_217569_E = ResourceUtil.getBlockSprite(propertiesTesr.getParticleTexture());
        }
    }
}

