/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.hives.IHiveTile;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.entities.ParticleSnow;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.particles.ApicultureParticles;
import forestry.apiculture.particles.BeeParticleData;
import forestry.apiculture.particles.BeeTargetParticleData;
import forestry.core.config.Config;
import forestry.core.entities.ParticleIgnition;
import forestry.core.entities.ParticleSmoke;
import forestry.core.utils.VectUtil;
import forestry.core.utils.WorldUtils;
import genetics.api.individual.IGenome;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleRender {
    private static final RedstoneParticleData HONEY_DUST = new RedstoneParticleData(0.9f, 0.75f, 0.0f, 1.0f);

    public static boolean shouldSpawnParticle(World world) {
        if (!Config.enableParticleFX) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ParticleStatus particleSetting = mc.field_71474_y.field_74362_aa;
        if (particleSetting == ParticleStatus.MINIMAL) {
            return world.field_73012_v.nextInt(10) == 0;
        }
        if (particleSetting == ParticleStatus.DECREASED) {
            return world.field_73012_v.nextInt(3) != 0;
        }
        return true;
    }

    public static void addBeeHiveFX(IBeeHousing housing, IGenome genome, List<BlockPos> flowerPositions) {
        List<LivingEntity> entitiesInRange;
        ClientWorld world = WorldUtils.asClient((IWorld)housing.getWorldObj());
        if (!ParticleRender.shouldSpawnParticle((World)world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Vector3d particleStart = housing.getBeeFXCoordinates();
        BlockPos playerPosition = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
        double playerDistanceSq = playerPosition.func_177951_i(new Vector3i(particleStart.field_72450_a, particleStart.field_72448_b, particleStart.field_72449_c));
        if ((double)world.field_73012_v.nextInt(1024) < playerDistanceSq) {
            return;
        }
        int color = genome.getActiveAllele(BeeChromosomes.SPECIES).getSpriteColour(0);
        int randomInt = world.field_73012_v.nextInt(100);
        if (housing instanceof IHiveTile && (((IHiveTile)((Object)housing)).isAngry() || randomInt >= 85) && !(entitiesInRange = AlleleEffect.getEntitiesInRange(genome, housing, LivingEntity.class)).isEmpty()) {
            LivingEntity entity = entitiesInRange.get(world.field_73012_v.nextInt(entitiesInRange.size()));
            world.func_195594_a((IParticleData)new BeeTargetParticleData((Entity)entity, color), particleStart.field_72450_a, particleStart.field_72448_b, particleStart.field_72449_c, 0.0, 0.0, 0.0);
            return;
        }
        if (randomInt < 75 && !flowerPositions.isEmpty()) {
            BlockPos destination = flowerPositions.get(world.field_73012_v.nextInt(flowerPositions.size()));
            world.func_195594_a((IParticleData)new BeeParticleData(ApicultureParticles.BEE_ROUND_TRIP_PARTICLE, destination, color), particleStart.field_72450_a, particleStart.field_72448_b, particleStart.field_72449_c, 0.0, 0.0, 0.0);
        } else {
            Vector3i area = AlleleEffect.getModifiedArea(genome, housing);
            BlockPos offset = housing.getCoordinates().func_177982_a(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
            BlockPos destination = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177971_a((Vector3i)offset);
            world.func_195594_a((IParticleData)new BeeParticleData(ApicultureParticles.BEE_EXPLORER_PARTICLE, destination, color), particleStart.field_72450_a, particleStart.field_72448_b, particleStart.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    public static void addEntityHoneyDustFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        world.func_195594_a((IParticleData)HONEY_DUST, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void addClimateParticles(World worldIn, BlockPos pos, Random rand, EnumTemperature temperature, EnumHumidity humidity) {
        if (!ParticleRender.shouldSpawnParticle(worldIn)) {
            return;
        }
        if (rand.nextFloat() >= 0.75f) {
            for (int i = 0; i < 3; ++i) {
                Direction facing = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                int xOffset = facing.func_82601_c();
                int zOffset = facing.func_82599_e();
                double x = (double)pos.func_177958_n() + 0.5 + ((double)(xOffset * 8) + (double)(1 - MathHelper.func_76130_a((int)xOffset)) * (0.5 - (double)rand.nextFloat()) * 8.0) / 16.0;
                double y = (double)pos.func_177956_o() + (0.75 + (double)rand.nextFloat() * 14.5) / 16.0;
                double z = (double)pos.func_177952_p() + 0.5 + ((double)(zOffset * 8) + (double)(1 - MathHelper.func_76130_a((int)zOffset)) * (0.5 - (double)rand.nextFloat()) * 8.0) / 16.0;
                if (rand.nextBoolean()) {
                    ParticleRender.addEntityClimateParticle(worldIn, x, y, z, temperature.color);
                    continue;
                }
                ParticleRender.addEntityClimateParticle(worldIn, x, y, z, humidity.color);
            }
        }
    }

    public static void addEntityClimateParticle(World world, double x, double y, double z, int color) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
    }

    public static void addTransformParticles(World worldIn, BlockPos pos, Random rand) {
        if (!ParticleRender.shouldSpawnParticle(worldIn)) {
            return;
        }
        if (rand.nextFloat() >= 0.65f) {
            for (int i = 0; i < 3; ++i) {
                Direction facing = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                int xOffset = facing.func_82601_c();
                int zOffset = facing.func_82599_e();
                double x = (double)pos.func_177958_n() + 0.5 + ((double)(xOffset * 8) + (double)(1 - MathHelper.func_76130_a((int)xOffset)) * (0.5 - (double)rand.nextFloat()) * 8.0) / 16.0;
                double y = (double)pos.func_177956_o() + (0.75 + (double)rand.nextFloat() * 14.5) / 16.0;
                double z = (double)pos.func_177952_p() + 0.5 + ((double)(zOffset * 8) + (double)(1 - MathHelper.func_76130_a((int)zOffset)) * (0.5 - (double)rand.nextFloat()) * 8.0) / 16.0;
                ParticleRender.addEntityTransformParticle(worldIn, x, y, z);
            }
        }
    }

    public static void addEntityTransformParticle(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
    }

    public static void addEntityExplodeFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Particle Particle2 = effectRenderer.func_199280_a((IParticleData)RedstoneParticleData.field_197564_a, x, y, z, 0.0, 0.0, 0.0);
        effectRenderer.func_78873_a(Particle2);
    }

    public static void addEntitySnowFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleSnow(WorldUtils.asClient((IWorld)world), x + world.field_73012_v.nextGaussian(), y, z + world.field_73012_v.nextGaussian()));
    }

    public static void addEntityIgnitionFX(ClientWorld world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle((World)world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleIgnition(world, x, y, z));
    }

    public static void addEntitySmokeFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        effectRenderer.func_78873_a((Particle)new ParticleSmoke(WorldUtils.asClient((IWorld)world), x, y, z));
    }

    public static void addEntityPotionFX(World world, double x, double y, double z, int color) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Particle particle = effectRenderer.func_199280_a((IParticleData)RedstoneParticleData.field_197564_a, x, y, z, 0.0, 0.0, 0.0);
        if (particle != null) {
            particle.func_70538_b(red, green, blue);
            effectRenderer.func_78873_a(particle);
        }
    }

    public static void addPortalFx(World world, BlockPos pos, Random rand) {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        double zPos;
        double yPos;
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        int j = rand.nextInt(2) * 2 - 1;
        int k = rand.nextInt(2) * 2 - 1;
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        double xPos = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
        Particle particle = effectRenderer.func_199280_a((IParticleData)RedstoneParticleData.field_197564_a, xPos, yPos = (double)((float)pos.func_177956_o() + rand.nextFloat()), zPos = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k, xSpeed = (double)(rand.nextFloat() * (float)j), ySpeed = ((double)rand.nextFloat() - 0.5) * 0.125, zSpeed = (double)(rand.nextFloat() * (float)k));
        if (particle != null) {
            effectRenderer.func_78873_a(particle);
        }
    }

    public static void addEntityBiodustFX(World world, double x, double y, double z) {
        if (!ParticleRender.shouldSpawnParticle(world)) {
            return;
        }
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        Particle particle = effectRenderer.func_199280_a((IParticleData)RedstoneParticleData.field_197564_a, x, y, z, 0.0, 0.0, 0.0);
        if (particle != null) {
            effectRenderer.func_78873_a(particle);
        }
    }
}

