/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderHelper {
    public static final Vector3f ORIGIN = new Vector3f(0.0f, 0.0f, 0.0f);
    public float partialTicks;
    public MatrixStack transformation;
    public IRenderTypeBuffer buffer;
    public int combinedLight;
    public int packetLight;
    public float rColor = 1.0f;
    public float bColor = 1.0f;
    public float gColor = 1.0f;
    public float alpha = 1.0f;
    @Nullable
    private ItemEntity dummyEntityItem;
    private long lastTick;
    private Vector3f baseRotation = ORIGIN;

    public void update(float partialTicks, MatrixStack transformation, IRenderTypeBuffer buffer, int combinedLight, int packetLight) {
        this.packetLight = packetLight;
        this.combinedLight = combinedLight;
        this.partialTicks = partialTicks;
        this.transformation = transformation;
        this.buffer = buffer;
    }

    private ItemEntity dummyItem(World world) {
        if (this.dummyEntityItem == null) {
            this.dummyEntityItem = new ItemEntity(world, 0.0, 0.0, 0.0);
        } else {
            this.dummyEntityItem.field_70170_p = world;
        }
        return this.dummyEntityItem;
    }

    public void renderItem(ItemStack stack, World world) {
        ItemEntity dummyItem = this.dummyItem(world);
        dummyItem.func_92058_a(stack);
        if (world.func_82737_E() != this.lastTick) {
            this.lastTick = world.func_82737_E();
            dummyItem.func_70071_h_();
        }
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.func_229084_a_((Entity)dummyItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, this.transformation, this.buffer, this.combinedLight);
        dummyItem.field_70170_p = null;
    }

    public void setRotation(Vector3f baseRotation) {
        this.baseRotation = baseRotation;
    }

    public void rotate(Quaternion rotation) {
        this.transformation.func_227863_a_(rotation);
    }

    public void translate(double x, double y, double z) {
        this.transformation.func_227861_a_(x, y, z);
    }

    public void scale(float x, float y, float z) {
        this.transformation.func_227862_a_(x, y, z);
    }

    public void color(float rColor, float gColor, float bColor) {
        this.color(rColor, gColor, bColor, 1.0f);
    }

    public void color(float rColor, float gColor, float bColor, float alpha) {
        this.rColor = rColor;
        this.gColor = gColor;
        this.bColor = bColor;
        this.alpha = alpha;
    }

    public void pop() {
        this.transformation.func_227865_b_();
    }

    public void push() {
        this.transformation.func_227860_a_();
    }

    public void renderModel(IVertexBuilder builder, ModelRenderer ... renderers) {
        this.renderModel(builder, ORIGIN, renderers);
    }

    public void renderModel(ResourceLocation location, ModelRenderer ... renderers) {
        this.renderModel(location, ORIGIN, renderers);
    }

    public void renderModel(IVertexBuilder builder, Vector3f rotation, ModelRenderer ... renderers) {
        for (ModelRenderer renderer : renderers) {
            renderer.field_78795_f = this.baseRotation.func_195899_a() + rotation.func_195899_a();
            renderer.field_78796_g = this.baseRotation.func_195900_b() + rotation.func_195900_b();
            renderer.field_78808_h = this.baseRotation.func_195902_c() + rotation.func_195902_c();
            renderer.func_228309_a_(this.transformation, builder, this.combinedLight, this.packetLight, this.rColor, this.gColor, this.bColor, this.alpha);
        }
    }

    public void renderModel(ResourceLocation location, Vector3f rotation, ModelRenderer ... renderers) {
        this.renderModel(this.buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)location)), rotation, renderers);
    }
}

