/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.blocks.BlockBase;
import forestry.core.fluids.ForestryFluids;
import forestry.core.render.EnumTankLevel;
import forestry.core.render.IForestryRenderer;
import forestry.core.render.RenderHelper;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;

public class RenderMachine
implements IForestryRenderer<TileBase> {
    private final ModelRenderer basefront;
    private final ModelRenderer baseback;
    private final ModelRenderer resourceTank;
    private final ModelRenderer productTank;
    private final ResourceLocation textureBase;
    private final ResourceLocation textureResourceTank;
    private final ResourceLocation textureProductTank;
    private final EnumMap<EnumTankLevel, ResourceLocation> texturesTankLevels = new EnumMap(EnumTankLevel.class);

    public RenderMachine(String baseTexture) {
        int textureWidth = 64;
        int textureHeight = 32;
        this.basefront = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.basefront.func_228300_a_(-8.0f, -8.0f, -8.0f, 16.0f, 4.0f, 16.0f);
        this.basefront.field_78800_c = 8.0f;
        this.basefront.field_78797_d = 8.0f;
        this.basefront.field_78798_e = 8.0f;
        this.baseback = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.baseback.func_228300_a_(-8.0f, 4.0f, -8.0f, 16.0f, 4.0f, 16.0f);
        this.baseback.field_78800_c = 8.0f;
        this.baseback.field_78797_d = 8.0f;
        this.baseback.field_78798_e = 8.0f;
        this.resourceTank = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.resourceTank.func_228300_a_(-6.0f, -8.0f, -6.0f, 12.0f, 16.0f, 6.0f);
        this.resourceTank.field_78800_c = 8.0f;
        this.resourceTank.field_78797_d = 8.0f;
        this.resourceTank.field_78798_e = 8.0f;
        this.productTank = new ModelRenderer(textureWidth, textureHeight, 0, 0);
        this.productTank.func_228300_a_(-6.0f, -8.0f, 0.0f, 12.0f, 16.0f, 6.0f);
        this.productTank.field_78800_c = 8.0f;
        this.productTank.field_78797_d = 8.0f;
        this.productTank.field_78798_e = 8.0f;
        this.textureBase = new ResourceLocation("forestry", baseTexture + "base.png");
        this.textureProductTank = new ResourceLocation("forestry", baseTexture + "tank_product_empty.png");
        this.textureResourceTank = new ResourceLocation("forestry", baseTexture + "tank_resource_empty.png");
        for (EnumTankLevel tankLevel : EnumTankLevel.values()) {
            if (tankLevel == EnumTankLevel.EMPTY) continue;
            String tankLevelString = tankLevel.toString().toLowerCase(Locale.ENGLISH);
            this.texturesTankLevels.put(tankLevel, new ResourceLocation("forestry", "textures/block/machine_tank_" + tankLevelString + ".png"));
        }
    }

    @Override
    public void renderTile(TileBase tile, RenderHelper helper) {
        IRenderableTile generator = (IRenderableTile)((Object)tile);
        World worldObj = tile.getWorldObj();
        BlockState blockState = worldObj.func_180495_p(tile.func_174877_v());
        if (blockState.func_177230_c() instanceof BlockBase) {
            Direction facing = (Direction)blockState.func_177229_b(BlockBase.FACING);
            this.render(generator.getResourceTankInfo(), generator.getProductTankInfo(), facing, helper);
        }
    }

    @Override
    public void renderItem(ItemStack stack, RenderHelper helper) {
        this.render(TankRenderInfo.EMPTY, TankRenderInfo.EMPTY, Direction.SOUTH, helper);
    }

    private void render(TankRenderInfo resourceTankInfo, TankRenderInfo productTankInfo, Direction orientation, RenderHelper helper) {
        Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        switch (orientation) {
            case EAST: {
                rotation.func_195905_a(0.0f, (float)Math.PI, -1.5707964f);
                break;
            }
            case WEST: {
                rotation.func_195905_a(0.0f, 0.0f, 1.5707964f);
                break;
            }
            case UP: {
                break;
            }
            case DOWN: {
                rotation.func_195905_a(0.0f, 0.0f, (float)Math.PI);
                break;
            }
            case SOUTH: {
                rotation.func_195905_a(1.5707964f, 0.0f, 1.5707964f);
                break;
            }
            default: {
                rotation.func_195905_a(-1.5707964f, 0.0f, 1.5707964f);
            }
        }
        helper.setRotation(rotation);
        helper.renderModel(this.textureBase, this.basefront, this.baseback);
        this.renderTank(this.resourceTank, this.textureResourceTank, resourceTankInfo, helper);
        this.renderTank(this.productTank, this.textureProductTank, productTankInfo, helper);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderTank(ModelRenderer tankModel, ResourceLocation textureBase, TankRenderInfo renderInfo, RenderHelper helper) {
        helper.renderModel(textureBase, tankModel);
        ResourceLocation textureResourceTankLevel = this.texturesTankLevels.get((Object)renderInfo.getLevel());
        if (textureResourceTankLevel == null) {
            return;
        }
        FluidAttributes attributes = renderInfo.getFluidStack().getFluid().getAttributes();
        int color = attributes.getColor();
        ForestryFluids definition = ForestryFluids.getFluidDefinition(renderInfo.getFluidStack().getFluid());
        if (color < 0) {
            color = Color.BLUE.getRGB();
            if (definition != null) {
                color = definition.getParticleColor().getRGB();
            }
        }
        float[] colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        helper.color(colors[0], colors[1], colors[2], 1.0f);
        helper.renderModel(textureResourceTankLevel, tankModel);
        helper.color(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

