/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryResource;
import forestry.core.render.IForestryRenderer;
import forestry.core.render.RenderHelper;
import forestry.core.tiles.TileNaturalistChest;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderNaturalistChest
implements IForestryRenderer<TileNaturalistChest> {
    private final ModelRenderer lid;
    private final ModelRenderer base = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer lock;
    private final ResourceLocation texture;

    public RenderNaturalistChest(String textureName) {
        this.base.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.lid = new ModelRenderer(64, 64, 0, 0);
        this.lid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.lid.field_78797_d = 9.0f;
        this.lid.field_78798_e = 1.0f;
        this.lock = new ModelRenderer(64, 64, 0, 0);
        this.lock.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.lock.field_78797_d = 8.0f;
        this.texture = new ForestryResource("textures/block/" + textureName + ".png");
    }

    @Override
    public void renderTile(TileNaturalistChest tile, RenderHelper helper) {
        World worldObj = tile.getWorldObj();
        BlockState blockState = worldObj.func_180495_p(tile.func_174877_v());
        if (blockState.func_177230_c() instanceof BlockBase) {
            Direction facing = (Direction)blockState.func_177229_b(BlockBase.FACING);
            this.render(facing, tile.prevLidAngle, tile.lidAngle, helper, helper.partialTicks);
        }
    }

    @Override
    public void renderItem(ItemStack stack, RenderHelper helper) {
        this.render(Direction.SOUTH, 0.0f, 0.0f, helper, helper.partialTicks);
    }

    public void render(Direction orientation, float prevLidAngle, float lidAngle, RenderHelper helper, float partialTick) {
        helper.push();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        helper.translate(0.5, 0.5, 0.5);
        helper.rotate(Vector3f.field_229181_d_.func_229187_a_(-orientation.func_185119_l()));
        helper.translate(-0.5, -0.5, -0.5);
        float angle = prevLidAngle + (lidAngle - prevLidAngle) * partialTick;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        float rotation = -(angle * (float)Math.PI / 2.0f);
        helper.renderModel(this.texture, new Vector3f(rotation, 0.0f, 0.0f), this.lid, this.lock);
        helper.renderModel(this.texture, this.base);
        helper.pop();
    }
}

